/*
 * Decompiled with CFR 0.152.
 */
package orch;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import javax.imageio.ImageIO;
import sos.io.SOSImageIO;
import sos.util.ColorVector;

public class ImagePiece {
    private File fileOfImage;
    private boolean hasImage;
    private boolean fixed = false;
    private int tableIndex;
    private Point tableLocation = new Point();
    private Rectangle bounds;
    private int[] pixelsData;
    private int[][] rgb;
    private Image thumbnail;
    private Dimension thumbnailSize = new Dimension();
    private int[][] histograms;
    private Rectangle partialBounds = new Rectangle();

    public ImagePiece(int width, int height, File file) {
        this.fileOfImage = file;
        this.thumbnailSize.width = width;
        this.thumbnailSize.height = height;
        this.makeThumbnail();
    }

    public String getPath() {
        if (this.fileOfImage == null) {
            return null;
        }
        return this.fileOfImage.getPath();
    }

    private int[] getPixels(Image img) {
        int[] pixels = new int[this.bounds.width * this.bounds.height];
        PixelGrabber grabber = new PixelGrabber(img, 0, 0, this.bounds.width, this.bounds.height, pixels, 0, this.bounds.width);
        try {
            grabber.grabPixels();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pixels;
    }

    private void makeThumbnail() {
        Dimension size = SOSImageIO.getImageSize(this.fileOfImage);
        this.bounds = new Rectangle(0, 0, size.width, size.height);
        int stepX = (int)Math.ceil(1.0 * (double)this.bounds.width / (double)this.thumbnailSize.width);
        int stepY = (int)Math.ceil(1.0 * (double)this.bounds.height / (double)this.thumbnailSize.height);
        int step = Math.max(stepX, stepY);
        this.thumbnail = null;
        this.thumbnail = step <= 1 ? SOSImageIO.readImage(this.fileOfImage) : SOSImageIO.getSubsampledImage(this.fileOfImage, step, step);
        this.hasImage = this.thumbnail != null;
    }

    public Image getThumbnail() {
        if (this.thumbnail == null) {
            this.makeThumbnail();
        }
        return this.thumbnail;
    }

    public void clearThumbnail() {
        this.thumbnail = null;
    }

    public boolean hasImage() {
        return this.hasImage;
    }

    public BufferedImage getImage() {
        BufferedImage img = null;
        try {
            img = ImageIO.read(this.fileOfImage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Dimension getSize() {
        return this.bounds.getSize();
    }

    public int[] getPixelsData() {
        if (this.pixelsData == null) {
            BufferedImage img = this.getImage();
            this.pixelsData = ColorVector.intRGBtoL(this.getPixels(img));
        }
        return this.pixelsData;
    }

    public int[] getPixelsData(int step) {
        if (this.pixelsData == null) {
            BufferedImage img = SOSImageIO.readImage(this.fileOfImage);
            Image subsampledImg = img.getScaledInstance(this.bounds.width / step, this.bounds.height / step, 16);
            Image expandImg = subsampledImg.getScaledInstance(this.bounds.width, this.bounds.height, 2);
            this.pixelsData = ColorVector.intRGBtoL(this.getPixels(expandImg));
        }
        return this.pixelsData;
    }

    public int[][] getRGB(int step) {
        if (this.rgb == null) {
            BufferedImage img = SOSImageIO.readImage(this.fileOfImage);
            Image subsampledImg = img.getScaledInstance(this.bounds.width / step, this.bounds.height / step, 16);
            Image expandImg = subsampledImg.getScaledInstance(this.bounds.width, this.bounds.height, 2);
            this.rgb = new int[this.bounds.width * this.bounds.height][3];
            ColorVector.getRGB(this.getPixels(expandImg), this.rgb);
        }
        return this.rgb;
    }

    public void clearRGB() {
        this.rgb = null;
    }

    public void clearPixelsData() {
        this.pixelsData = null;
    }

    public int getThumbnailOriginalRatio() {
        return this.bounds.width / this.thumbnailSize.width;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public int getIndex() {
        return this.tableIndex;
    }

    public void setIndex(int index) {
        this.tableIndex = index;
    }

    public Point getTableLocation() {
        return this.tableLocation;
    }

    public void setTableLocation(int x, int y) {
        this.tableLocation.setLocation(x, y);
    }

    private void makeReferenceHistogram() {
        if (this.histograms == null) {
            this.histograms = new int[4][];
            this.partialBounds.setLocation(0, 0);
            this.histograms[0] = this.makeHistogram();
            this.partialBounds.setLocation(this.bounds.width - this.partialBounds.width, 0);
            this.histograms[1] = this.makeHistogram();
            this.partialBounds.setLocation(this.bounds.width - this.partialBounds.width, this.bounds.height - this.partialBounds.height);
            this.histograms[2] = this.makeHistogram();
            this.partialBounds.setLocation(0, this.bounds.height - this.partialBounds.height);
            this.histograms[3] = this.makeHistogram();
        }
    }

    public int[][] getReferenceHistogram(int direction) {
        this.makeReferenceHistogram();
        int[][] result = new int[2][];
        switch (direction) {
            case 0: {
                result[0] = this.histograms[0];
                result[1] = this.histograms[1];
                break;
            }
            case 1: {
                result[0] = this.histograms[0];
                result[1] = this.histograms[3];
                break;
            }
            case 2: {
                result[0] = this.histograms[3];
                result[1] = this.histograms[2];
                break;
            }
            case 3: {
                result[0] = this.histograms[1];
                result[1] = this.histograms[2];
            }
        }
        return result;
    }

    private int[] makeHistogram() {
        if (this.rgb == null) {
            BufferedImage img = this.getImage();
            int[] intRGB = this.getPixels(img);
            this.rgb = new int[intRGB.length][3];
            ColorVector.getRGB(intRGB, this.rgb);
        }
        int step = 64;
        int nColor = 256 / step;
        int nColor2 = nColor * nColor;
        int[] histogram = new int[nColor * nColor2];
        for (int y = this.partialBounds.y; y < this.partialBounds.y + this.partialBounds.height; ++y) {
            for (int x = this.partialBounds.x; x < this.partialBounds.x + this.partialBounds.width; ++x) {
                int colorIndex;
                int locationIndex = x + y * this.bounds.width;
                int n = colorIndex = nColor2 * (this.rgb[locationIndex][0] / step) + nColor * (this.rgb[locationIndex][1] / step) + this.rgb[locationIndex][2] / step;
                histogram[n] = histogram[n] + 1;
            }
        }
        return histogram;
    }

    public double collate(int[] referenceHistogram) {
        int[] inputHistogram = this.makeHistogram();
        int sum = 0;
        for (int i = 0; i < referenceHistogram.length; ++i) {
            sum += Math.min(referenceHistogram[i], inputHistogram[i]);
        }
        double result = 1.0 * (double)sum / (double)(this.partialBounds.width * this.partialBounds.height);
        return result;
    }

    public double calcSimilarityUpperLimit(Rectangle rect, double similarity) {
        Rectangle interRect = rect.intersection(this.partialBounds);
        int interRectSize = interRect.width * interRect.height;
        int partialBoundsSize = this.partialBounds.width * this.partialBounds.height;
        int diff = partialBoundsSize - interRectSize;
        diff = 0;
        return (Math.min(similarity * (double)partialBoundsSize, (double)interRectSize) + (double)diff) / (double)partialBoundsSize;
    }

    public boolean canSkip(Rectangle rect, double similarity, double maxCandidate) {
        Rectangle interRect = rect.intersection(this.partialBounds);
        int partialBoundsSize = this.partialBounds.width * this.partialBounds.height;
        int interRectSize = interRect.width * interRect.height;
        return (double)(partialBoundsSize - interRectSize) <= (double)partialBoundsSize * (maxCandidate - similarity);
    }

    public Rectangle getPartialBounds() {
        return (Rectangle)this.partialBounds.clone();
    }

    public void setPartialLocation(int x, int y) {
        this.partialBounds.setLocation(x, y);
    }

    public void setPartialSize(double ratioW, double ratioH) {
        int refWidth = (int)((double)this.bounds.width * ratioW);
        int refHeight = (int)((double)this.bounds.height * ratioH);
        this.partialBounds.setSize(refWidth, refHeight);
    }
}

