/*
 * Decompiled with CFR 0.152.
 */
package orch;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import orch.ImagePiece;

public class JDropableTable
extends JTable
implements DropTargetListener,
MouseMotionListener,
Serializable {
    private DropTarget dropTarget = null;
    private boolean dragging;
    private Point startPoint;

    public JDropableTable() {
        this.setDefaultEditor(Object.class, null);
        this.addMouseMotionListener(this);
        this.dropTarget = new DropTarget(this, 3, this, true);
    }

    public void applyCellSize() {
        int i;
        TableColumnModel model = this.getColumnModel();
        for (i = 0; i < this.getColumnCount(); ++i) {
            TableColumn Tcol = model.getColumn(i);
            if (i % 2 == 0) {
                Tcol.setMinWidth(5);
                Tcol.setPreferredWidth(5);
                continue;
            }
            Tcol.setPreferredWidth(160);
        }
        for (i = 0; i < this.getRowCount(); ++i) {
            if (i % 2 == 0) {
                this.setRowHeight(i, 5);
                continue;
            }
            this.setRowHeight(i, 120);
        }
    }

    public void clearContents() {
        for (int y = 0; y < this.getRowCount(); ++y) {
            for (int x = 0; x < this.getColumnCount(); ++x) {
                this.setValueAt(null, y, x);
            }
        }
    }

    private void changeSelectedCell(Point p) {
        int rowIndex = this.rowAtPoint(p);
        int columnIndex = this.columnAtPoint(p);
        this.changeSelection(rowIndex, columnIndex, false, false);
    }

    public void setTable(int row, int column) {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        model.setColumnCount(column);
        model.setRowCount(row);
        this.applyCellSize();
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean value) {
        this.dragging = value;
    }

    public void removeColumnAndData(int colIndex, int nColumn) {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        int oldColumnCount = model.getColumnCount();
        for (int x = colIndex + nColumn; x < this.getColumnCount(); ++x) {
            for (int y = 0; y < model.getRowCount(); ++y) {
                Object data = model.getValueAt(y, x);
                model.setValueAt(data, y, x - nColumn);
            }
        }
        model.setColumnCount(oldColumnCount - nColumn);
        this.applyCellSize();
    }

    public void dragEnter(DropTargetDragEvent e) {
        e.acceptDrag(3);
    }

    public void drop(DropTargetDropEvent e) {
        e.acceptDrop(3);
        try {
            if ((e.getDropAction() & 3) != 0) {
                boolean canvasColumn;
                boolean canvasRow = this.getSelectedRow() % 2 != 0;
                boolean bl = canvasColumn = this.getSelectedColumn() % 2 != 0;
                if (!canvasRow && !canvasColumn) {
                    e.dropComplete(true);
                    this.dragging = false;
                    return;
                }
                File file = null;
                if (e.isLocalTransfer()) {
                    int sourceRowIndex = this.rowAtPoint(this.startPoint);
                    int sourceColumnIndex = this.columnAtPoint(this.startPoint);
                    ImagePiece tn = (ImagePiece)this.getModel().getValueAt(sourceRowIndex, sourceColumnIndex);
                    if (tn != null && tn.hasImage()) {
                        file = new File(tn.getPath());
                        this.getModel().setValueAt(null, sourceRowIndex, sourceColumnIndex);
                    } else {
                        file = null;
                    }
                } else {
                    Transferable trans = e.getTransferable();
                    List list = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                    file = (File)list.get(0);
                }
                if (file != null) {
                    ImagePiece thumbnail = new ImagePiece(160, 120, file);
                    int targetRow = this.getSelectedRow();
                    int targetColumn = this.getSelectedColumn();
                    if (canvasRow ^ canvasColumn) {
                        DefaultTableModel model = (DefaultTableModel)this.getModel();
                        if (canvasRow) {
                            int oldColumnCount = model.getColumnCount();
                            model.setColumnCount(oldColumnCount + 2);
                            for (int x = oldColumnCount - 2; x > targetColumn; x -= 2) {
                                for (int y = 0; y < model.getRowCount(); ++y) {
                                    Object data = model.getValueAt(y, x);
                                    model.setValueAt(data, y, x + 2);
                                }
                            }
                            ++targetColumn;
                            for (int y = 0; y < model.getRowCount(); ++y) {
                                model.setValueAt(null, y, targetColumn);
                            }
                        } else {
                            Object[] obj = new Object[model.getColumnCount()];
                            model.insertRow(targetRow, obj);
                            model.insertRow(targetRow, obj);
                            ++targetRow;
                        }
                        this.applyCellSize();
                    }
                    this.getModel().setValueAt(thumbnail, targetRow, targetColumn);
                }
                e.dropComplete(true);
            } else {
                e.dropComplete(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            e.dropComplete(false);
        }
        this.dragging = false;
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
        this.changeSelectedCell(e.getLocation());
        this.dragging = true;
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void mouseDragged(MouseEvent evt) {
        if (!this.dragging) {
            this.dragging = true;
            this.startPoint = evt.getPoint();
        }
    }

    public void mouseMoved(MouseEvent evt) {
        this.changeSelectedCell(evt.getPoint());
    }
}

