/*
 * Decompiled with CFR 0.152.
 */
package orch.plugin;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedList;
import orch.ImagePiece;
import orch.plugin.CollatedPoint;
import orch.plugin.Matching;
import sos.util.MinMaxDouble;

public class ActiveSearchMatching
extends Matching {
    protected Rectangle getSearchBounds(ImagePiece ipUnmove, ImagePiece ipMove, boolean isHorizontal) {
        boolean reverseUnion = ipUnmove.getIndex() >= ipMove.getIndex();
        Rectangle rect = ipUnmove.getBounds();
        Rectangle result = new Rectangle();
        double overlapRatio = 0.6;
        if (isHorizontal) {
            ipUnmove.setPartialSize(0.05, 1.0 - overlapRatio);
            ipMove.setPartialSize(0.05, 1.0 - overlapRatio);
            Rectangle partial = ipUnmove.getPartialBounds();
            int range = (int)(overlapRatio * (double)rect.width);
            if (reverseUnion) {
                result.setLocation(0, rect.y);
            } else {
                result.setLocation(rect.x + rect.width - range, rect.y);
            }
            result.setSize(range - partial.width, rect.height - partial.height);
        } else {
            ipUnmove.setPartialSize(1.0 - overlapRatio, 0.05);
            ipMove.setPartialSize(1.0 - overlapRatio, 0.05);
            Rectangle partial = ipUnmove.getPartialBounds();
            int range = (int)(overlapRatio * (double)rect.height);
            if (reverseUnion) {
                result.setLocation(rect.x, 0);
            } else {
                result.setLocation(rect.x, rect.y + rect.height - range);
            }
            result.setSize(rect.width - partial.width, range - partial.height);
        }
        return result;
    }

    protected void matchThreeImage(ImagePiece ipUnmove, ImagePiece ipMove, ImagePiece ipSub, boolean isHorizontal) {
        this.matchTwoImage(ipUnmove, ipMove, isHorizontal);
    }

    protected void matchTwoImage(ImagePiece ipUnmove, ImagePiece ipMove, boolean isHorizontal) {
        Point p = new Point();
        int direction = 0;
        if (isHorizontal) {
            if (ipUnmove.getIndex() < ipMove.getIndex()) {
                direction = 1;
                p.setLocation(0, -this.searchBounds.height);
            } else {
                direction = 3;
            }
        } else if (ipUnmove.getIndex() < ipMove.getIndex()) {
            direction = 0;
            p.setLocation(-this.searchBounds.width, 0);
        } else {
            direction = 2;
        }
        int[][] reference = ipMove.getReferenceHistogram(direction);
        CollatedPoint[] best = new CollatedPoint[2];
        double maxCandidate = 0.8;
        best[0] = this.findBestCollatedPoint(ipUnmove, ipMove, reference[0], maxCandidate);
        maxCandidate = best[0].value;
        best[1] = this.findBestCollatedPoint(ipUnmove, ipMove, reference[1], maxCandidate);
        this.matchedPoint = best[0].rect.getLocation();
        if (best[0].value < best[1].value) {
            this.matchedPoint = best[1].rect.getLocation();
            this.matchedPoint.x += p.x;
            this.matchedPoint.y += p.y;
        }
    }

    private CollatedPoint findBestCollatedPoint(ImagePiece ipUnmove, ImagePiece ipMove, int[] reference, double maxCandidate) {
        boolean[] searched = new boolean[this.searchBounds.width * this.searchBounds.height];
        LinkedList<Rectangle> expandRegion = new LinkedList<Rectangle>();
        LinkedList<CollatedPoint> collations = new LinkedList<CollatedPoint>();
        int maxX = this.searchBounds.x + this.searchBounds.width;
        int maxY = this.searchBounds.y + this.searchBounds.height;
        Rectangle matched = null;
        ipUnmove.setPartialLocation(this.searchBounds.x, this.searchBounds.y);
        double currentSimilarity = ipUnmove.collate(reference);
        System.out.println(currentSimilarity);
        collations.add(new CollatedPoint(ipUnmove.getPartialBounds(), currentSimilarity, 0));
        MinMaxDouble mmd = new MinMaxDouble();
        mmd.setInit(currentSimilarity);
        int searchCount = 0;
        do {
            CollatedPoint cp = (CollatedPoint)collations.removeFirst();
            Rectangle currentRefRect = cp.rect;
            currentSimilarity = cp.value;
            expandRegion.add(currentRefRect);
            do {
                Rectangle rect = (Rectangle)expandRegion.removeFirst();
                for (int j = 0; j < 4; ++j) {
                    int index;
                    int x = rect.x + dX[j];
                    int y = rect.y + dY[j];
                    if (this.pauseFlag || this.searchBounds.x > x || x >= maxX || this.searchBounds.y > y || y >= maxY || searched[index = x - this.searchBounds.x + (y - this.searchBounds.y) * this.searchBounds.width]) continue;
                    searched[index] = true;
                    ipUnmove.setPartialLocation(x, y);
                    if (ipUnmove.canSkip(currentRefRect, currentSimilarity, maxCandidate)) {
                        expandRegion.add(ipUnmove.getPartialBounds());
                        continue;
                    }
                    ++searchCount;
                    double similarity = ipUnmove.collate(reference);
                    collations.add(new CollatedPoint(ipUnmove.getPartialBounds(), similarity, index));
                    if (!mmd.compareMax(similarity)) continue;
                    maxCandidate = mmd.getValue();
                    matched = ipUnmove.getPartialBounds();
                    this.matchedPoint = matched.getLocation();
                    this.drawRects(ipUnmove, ipMove, null, null, null);
                }
            } while (0 < expandRegion.size());
        } while (0 < collations.size());
        System.out.println(searchCount + "/" + searched.length);
        System.out.println("MAX=" + mmd.getValue());
        return new CollatedPoint(matched, mmd.getValue(), 0);
    }
}

