unit SLAPI;

interface

uses
  Windows, ShlObj;

var
  ExistsSLAPI: Boolean;

const
  // PadX.ini  DragBar ̒l
  DS_NONE = 0; // \Ȃ
  DS_LEFT = 1; // 
  DS_TOP = 2; // 
  DS_RIGHT = 3; // E
  DS_BOTTOM = 4; // 

  // PadX.ini  DropAction ̒l
  DA_ADDHERE = 0; // hbvꏊɒǉ
  DA_ADDLAST = 1; // Ōɒǉ
  DA_OPENHERE = 2; // hbṽ{^ŊJ
  DA_COPYNAME = 3; // t@CRs[

  // PadX.ini  BtnCaption ̒l
  CA_COMLINE = 0; // w肵ĎsJ
  CA_BTNEDIT = 1; // {^̕ҏWJ
  CA_GRPCHANGE = 2; // {^O[vύXj[J
  CA_NEXTGROUP = 3; // ̃{^O[vֈړ
  CA_PADPRO = 4; // pbh̐ݒJ
  CA_OPTION = 5; // Ŝ̐ݒJ
  CA_HIDE = 6; // pbhB

  // PadX.ini  BtnCaption ̒l
  CP_NONE = 0; // {^\Ȃ
  CP_BOTTOM = 1; // ACR̉
  CP_RIGHT = 2; // ACR̉E

type
  // {^O[v̏
  PSLAGroup = ^TSLAGroup;
  TSLAGroup = packed record
    PadID: Integer; // pbhID
    GroupIndex: Integer; // O[ṽCfbNX
    Name: array[0..1023] of Char; // {^O[v
    ButtonCount: Integer; // {^̐
  end;

const
  // TSLAButton  Kind ̒l
  BK_SPACE = 0;
  BK_RETURN = 1;
  BK_NORMAL = 2;
  BK_PLUGIN = 3;

  // TSLAButton  WindowSize ̒l
  BW_NORMAL = 0;
  BW_MINIMIZED = 1;
  BW_MAXMIZED = 2;

type
  // {^̏
  PSLAButton = ^TSLAButton;
  TSLAButton = packed record
    PadID: Integer; // pbhIDiǂݎ̂݁j
    GroupIndex: Integer; // O[ṽCfbNXiǂݎ̂݁j
    ButtonIndex: Integer; // {^̃CfbNXiǂݎ̂݁j

    ScreenRect: TRect; // ʏł̍Wiǂݎ̂݁j

    Name: array[0..1023] of Char; // {^
    ClickCount: Integer; // NbN
    Kind: Integer; // {^̎

    FileName: array[0..1023] of Char; // Ñt@C
    ItemIDList: PItemIDList; // NPIDL
    Option: array[0..1023] of Char; // s
    Folder: array[0..1023] of Char; // ƗptH_
    WindowSize: Integer; // s̑傫
    IconFile: array[0..1023] of Char; // ACRt@C
    IconIndex: Integer; // ACR̃CfbNX

    PluginName: array[0..1023] of Char; // vOC̖O
    PluginNo: Integer; // vOC{^̔ԍ
  end;

const
  // SLAGetIcon  FileType ̒l
  FT_ICONPATH = 0; // ACR܂܂t@Cւ̃pX
  FT_FILEPATH = 1; // ʏ̃t@Cւ̃pX
  FT_PIDL = 2; // PIDL

var
  // pbh̐擾
  SLAGetPadCount: function: Integer; stdcall;
  // hWnd  PadID 擾
  SLAGetPadID: function(hWnd: HWND): Integer; stdcall;
  // PadID 玟 PadID 擾
  SLAGetNextPadID: function(ID: Integer): Integer; stdcall;
  // PadID pbh̃EBhEnh擾
  SLAGetPadWnd: function(ID: Integer): HWND; stdcall;
  // PadID pbh̉BĂ鎞̃EBhEnh擾
  SLAGetPadTabWnd: function(ID: Integer): HWND; stdcall;
  // pbh̃vpeB 1 擾
  SLAGetPadInit: function(ID: Integer; Key: PChar; Buf: PChar; BufSize: Integer): BOOL; stdcall;
  // pbh̃vpeB 1 Zbg
  SLASetPadInit: function(ID: Integer; Key: PChar; Item: PChar): BOOL; stdcall;

  // vOC{^ēx擾
  SLAChangePluginButtons: function(Name: PChar): BOOL; stdcall;
  // vOCj[ēx擾
  SLAChangePluginMenus: function(Name: PChar): BOOL; stdcall;
  // vOC{^ĕ`悷
  SLARedrawPluginButtons: function(Name: PChar; No: Integer): BOOL; stdcall;

  // {^O[v̐擾
  SLAGetGroupCount: function(ID: Integer): Integer; stdcall;
  // {^O[v̏擾
  SLAGetGroup: function(ID, GroupIndex: Integer; Group: PSLAGroup): BOOL; stdcall;
  // {^O[v}
  SLAInsertGroup: function(ID, GroupIndex: Integer; Name: PChar): BOOL; stdcall;
  // {^O[v̖OύX
  SLARenameGroup: function(ID, GroupIndex: Integer; Name: PChar): BOOL; stdcall;
  // {^O[v𕡐
  SLACopyGroup: function(ID, GroupIndex, NewIndex: Integer): BOOL; stdcall;
  // {^O[v폜
  SLADeleteGroup: function(ID, GroupIndex: Integer): BOOL; stdcall;

  // {^̏擾
  SLAGetButton: function(ID, GroupIndex, ButtonIndex: Integer; Button: PSLAButton): BOOL; stdcall;
  // {^}
  SLAInsertButton: function(ID, GroupIndex, ButtonIndex: Integer; Button: PSLAButton): BOOL; stdcall;
  // {^ύX
  SLAChangeButton: function(ID, GroupIndex, ButtonIndex: Integer; Button: PSLAButton): BOOL; stdcall;
  // {^폜
  SLADeleteButton: function(ID, GroupIndex, ButtonIndex: Integer): BOOL; stdcall;
  // {^Nbv{[hɃRs[
  SLACopyButton: function(ID, GroupIndex, ButtonIndex: Integer): BOOL; stdcall;
  // {^Nbv{[h\t
  SLAPasteButton: function(ID, GroupIndex, ButtonIndex: Integer): BOOL; stdcall;
  // Nbv{[hɃ{^œ\tf[^邩Ԃ
  SLAButtonInClipbord: function: BOOL; stdcall;
  // {^f[^s
  SLARunButton: function (ID: Integer; Button: PSLAButton): BOOL; stdcall;

  // ACR擾
  SLAGetIcon: function(FilePoint: Pointer; FileType, IconIndex: Integer; SmallIcon, UseCache: BOOL): HIcon; stdcall;

var
  InstSpLnch: THandle;

implementation

procedure InitAPI;
begin
  InstSpLnch := GetModuleHandle(nil);
  if  InstSpLnch < HINSTANCE_ERROR then
  begin
    InstSpLnch := 0;
    Exit;
  end;
  @SLAGetPadCount := GetProcAddress(InstSpLnch, 'SLAGetPadCount');
  @SLAGetPadID := GetProcAddress(InstSpLnch, 'SLAGetPadID');
  @SLAGetNextPadID := GetProcAddress(InstSpLnch, 'SLAGetNextPadID');
  @SLAGetPadWnd := GetProcAddress(InstSpLnch, 'SLAGetPadWnd');
  @SLAGetPadTabWnd := GetProcAddress(InstSpLnch, 'SLAGetPadTabWnd');
  @SLAGetPadInit := GetProcAddress(InstSpLnch, 'SLAGetPadInit');
  @SLASetPadInit := GetProcAddress(InstSpLnch, 'SLASetPadInit');
  @SLAChangePluginButtons := GetProcAddress(InstSpLnch, 'SLAChangePluginButtons');
  @SLAChangePluginMenus := GetProcAddress(InstSpLnch, 'SLAChangePluginMenus');
  @SLARedrawPluginButtons := GetProcAddress(InstSpLnch, 'SLARedrawPluginButtons');
  @SLAGetGroupCount := GetProcAddress(InstSpLnch, 'SLAGetGroupCount');
  @SLAGetGroup := GetProcAddress(InstSpLnch, 'SLAGetGroup');
  @SLAInsertGroup := GetProcAddress(InstSpLnch, 'SLAInsertGroup');
  @SLARenameGroup := GetProcAddress(InstSpLnch, 'SLARenameGroup');
  @SLACopyGroup := GetProcAddress(InstSpLnch, 'SLACopyGroup');
  @SLADeleteGroup := GetProcAddress(InstSpLnch, 'SLADeleteGroup');
  @SLAGetButton := GetProcAddress(InstSpLnch, 'SLAGetButton');
  @SLAInsertButton := GetProcAddress(InstSpLnch, 'SLAInsertButton');
  @SLAChangeButton := GetProcAddress(InstSpLnch, 'SLAChangeButton');
  @SLADeleteButton := GetProcAddress(InstSpLnch, 'SLADeleteButton');
  @SLACopyButton := GetProcAddress(InstSpLnch, 'SLACopyButton');
  @SLAPasteButton := GetProcAddress(InstSpLnch, 'SLAPasteButton');
  @SLAButtonInClipbord := GetProcAddress(InstSpLnch, 'SLAButtonInClipbord');
  @SLARunButton := GetProcAddress(InstSpLnch, 'SLARunButton');
  @SLAGetIcon := GetProcAddress(InstSpLnch, 'SLAGetIcon');

  ExistsSLAPI :=
    (@SLAGetPadCount <> nil) and
    (@SLAGetPadID <> nil) and
    (@SLAGetNextPadID <> nil) and
    (@SLAGetPadWnd <> nil) and
    (@SLAGetPadTabWnd <> nil) and
    (@SLAGetPadInit <> nil) and
    (@SLASetPadInit <> nil) and
    (@SLAChangePluginButtons <> nil) and
    (@SLAChangePluginMenus <> nil) and
    (@SLARedrawPluginButtons <> nil) and
    (@SLAGetGroupCount <> nil) and
    (@SLAGetGroup <> nil) and
    (@SLAInsertGroup <> nil) and
    (@SLARenameGroup <> nil) and
    (@SLACopyGroup <> nil) and
    (@SLADeleteGroup <> nil) and
    (@SLAGetButton <> nil) and
    (@SLAInsertButton <> nil) and
    (@SLAChangeButton <> nil) and
    (@SLADeleteButton <> nil) and
    (@SLACopyButton <> nil) and
    (@SLAPasteButton <> nil) and
    (@SLAButtonInClipbord <> nil) and
    (@SLARunButton <> nil) and
    (@SLAGetIcon <> nil);
end;



initialization
  InitAPI;
end.
