/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LocalizedDescriptionManager {
    private Map<Locale, ResourceBundle> resources = new HashMap<Locale, ResourceBundle>();
    private static LocalizedDescriptionManager manager = new LocalizedDescriptionManager();

    private LocalizedDescriptionManager() {
    }

    public String getDisplayType(Locale locale, String birthmarkType) {
        try {
            return this.getBundle(locale).getString("birthmark." + birthmarkType + ".display.type");
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public String getDescription(Locale locale, String birthmarkType) {
        try {
            return this.getBundle(locale).getString("birthmark." + birthmarkType + ".description");
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private ResourceBundle getBundle(Locale locale) {
        ResourceBundle bundle = this.resources.get(locale);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("resources.description", locale);
            this.resources.put(locale, bundle);
        }
        return bundle;
    }

    public static LocalizedDescriptionManager getInstance() {
        return manager;
    }
}

