/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.util.ArrayList;
import java.util.Iterator;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.ComparisonPairElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonPair
implements Iterable<ComparisonPairElement> {
    private BirthmarkSet target1;
    private BirthmarkSet target2;
    private BirthmarkContext context;

    public ComparisonPair(BirthmarkSet target1, BirthmarkSet target2, BirthmarkContext context) {
        this.target1 = target1;
        this.target2 = target2;
        this.context = context;
        if (target1.getBirthmarksCount() != target2.getBirthmarksCount()) {
            throw new IllegalArgumentException("birthmark count is not matched");
        }
    }

    public BirthmarkSet getTarget1() {
        return this.target1;
    }

    public BirthmarkSet getTarget2() {
        return this.target2;
    }

    public double calculateSimilarity() {
        double similarity = 0.0;
        for (ComparisonPairElement elem : this) {
            similarity += elem.getSimilarity();
        }
        return similarity / (double)this.getBirthmarksCount();
    }

    public int getBirthmarksCount() {
        return this.target1.getBirthmarksCount();
    }

    @Override
    public synchronized Iterator<ComparisonPairElement> iterator() {
        ArrayList<ComparisonPairElement> list = new ArrayList<ComparisonPairElement>();
        Iterator<String> i = this.target1.birthmarkTypes();
        while (i.hasNext()) {
            String type = i.next();
            Birthmark b1 = this.target1.getBirthmark(type);
            Birthmark b2 = this.target2.getBirthmark(type);
            if (b1 == null || b2 == null) continue;
            list.add(new ComparisonPairElement(b1, b2, this.context.getService(type).getComparator()));
        }
        return list.iterator();
    }
}

