/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks.kgram;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.birthmarks.BirthmarkExtractVisitor;
import jp.naist.se.stigmata.birthmarks.kgram.KGram;
import jp.naist.se.stigmata.birthmarks.kgram.KGramBasedBirthmarkElement;
import jp.naist.se.stigmata.birthmarks.kgram.OpcodeExtractionMethodVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class KGramBasedBirthmarkExtractVisitor
extends BirthmarkExtractVisitor {
    private Birthmark birthmark;
    private int kvalue;
    private List<Integer> opcodes = new ArrayList<Integer>();

    public KGramBasedBirthmarkExtractVisitor(ClassVisitor visitor, Birthmark birthmark, BirthmarkContext context) {
        super(visitor, context);
        this.birthmark = birthmark;
    }

    public int getKValue() {
        return this.kvalue;
    }

    public void setKValue(int kvalue) {
        this.kvalue = kvalue;
    }

    public void visitEnd() {
        HashSet<KGram> kgrams = new HashSet<KGram>();
        if (this.opcodes.size() >= this.getKValue()) {
            int kvalue = this.getKValue();
            int max = this.opcodes.size() - (kvalue - 1);
            for (int i = 0; i < max; ++i) {
                KGram kgram = new KGram(kvalue);
                for (int j = 0; j < kvalue; ++j) {
                    kgram.set(j, this.opcodes.get(i + j));
                }
                kgrams.add(kgram);
            }
        }
        for (KGram kgram : kgrams) {
            this.birthmark.addElement(new KGramBasedBirthmarkElement(kgram));
        }
    }

    public MethodVisitor visitMethod(int arg0, String arg1, String arg2, String arg3, String[] arg4) {
        MethodVisitor visitor = super.visitMethod(arg0, arg1, arg2, arg3, arg4);
        OpcodeExtractionMethodVisitor opcodeVisitor = new OpcodeExtractionMethodVisitor(visitor, this.opcodes);
        return opcodeVisitor;
    }
}

