/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import jp.naist.se.stigmata.ui.swing.BirthmarkSelectablePane;
import jp.naist.se.stigmata.ui.swing.BirthmarkSelection;
import jp.naist.se.stigmata.ui.swing.BirthmarkServiceListCellRenderer;
import jp.naist.se.stigmata.ui.swing.BirthmarkServiceListener;
import jp.naist.se.stigmata.ui.swing.DataChangeListener;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.Utility;

public class BirthmarkSelectionListPane
extends BirthmarkSelectablePane
implements BirthmarkServiceListener {
    private static final long serialVersionUID = 3209854654743223453L;
    private StigmataFrame stigmata;
    private List<DataChangeListener> listeners = new ArrayList<DataChangeListener>();
    private Set<String> selectedServices = new HashSet<String>();
    private Map<String, BirthmarkSelection> services;
    private boolean expertmode = false;
    private DefaultListModel model;
    private JList list;

    public BirthmarkSelectionListPane(StigmataFrame stigmata) {
        this.stigmata = stigmata;
        this.initLayouts();
        this.initServices();
        stigmata.addBirthmarkServiceListener(this);
    }

    private void initLayouts() {
        this.setLayout(new BorderLayout());
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        JScrollPane scroll = new JScrollPane(this.list);
        this.add((Component)scroll, "Center");
        this.list.setCellRenderer(new BirthmarkServiceListCellRenderer(new Dimension(250, 20), 60));
        this.list.setVisibleRowCount(5);
        JButton checkAll = Utility.createButton("checkall");
        JButton uncheckAll = Utility.createButton("uncheckall");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(checkAll);
        box.add(Box.createHorizontalGlue());
        box.add(uncheckAll);
        box.add(Box.createHorizontalGlue());
        this.add((Component)box, "South");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean flag = e.getActionCommand().equals("checkall");
                for (String key : BirthmarkSelectionListPane.this.services.keySet()) {
                    BirthmarkSelection le = (BirthmarkSelection)BirthmarkSelectionListPane.this.services.get(key);
                    le.setSelected(flag);
                    BirthmarkSelectionListPane.this.updateUI();
                    BirthmarkSelectionListPane.this.fireEvent();
                }
            }
        };
        checkAll.addActionListener(listener);
        uncheckAll.addActionListener(listener);
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int index = BirthmarkSelectionListPane.this.list.locationToIndex(e.getPoint());
                BirthmarkSelectionListPane.this.list.setSelectedIndex(index);
                BirthmarkSelection elem = (BirthmarkSelection)BirthmarkSelectionListPane.this.model.getElementAt(index);
                elem.setSelected(!elem.isSelected());
                BirthmarkSelectionListPane.this.updateUI();
            }
        });
    }

    public void select(BirthmarkSpi service, boolean flag) {
        if (flag) {
            this.selectedServices.add(service.getType());
        } else {
            this.selectedServices.remove(service.getType());
        }
        this.fireEvent();
    }

    public void refresh() {
        this.initServices();
        this.updateLayouts();
    }

    public void setExpertMode(boolean expertmode) {
        this.expertmode = expertmode;
        this.updateLayouts();
    }

    public boolean isExpertMode() {
        return this.expertmode;
    }

    public void reset() {
        this.selectedServices.clear();
        this.initServices();
        this.expertmode = false;
        this.updateLayouts();
        this.fireEvent();
    }

    public void addDataChangeListener(DataChangeListener listener) {
        this.listeners.add(listener);
    }

    public String[] getServices() {
        String[] serviceArray = new String[this.services.size()];
        int index = 0;
        for (String key : this.services.keySet()) {
            BirthmarkSpi service = this.services.get(key).getService();
            serviceArray[index] = service.getType();
            ++index;
        }
        return serviceArray;
    }

    public String[] getSelectedServices() {
        return this.selectedServices.toArray(new String[this.selectedServices.size()]);
    }

    public void serviceAdded(BirthmarkSpi service) {
        if (this.services.get(service.getType()) == null) {
            BirthmarkSelection elem = new BirthmarkSelection(service);
            this.selectedServices.add(service.getType());
            this.services.put(service.getType(), elem);
        }
        this.updateLayouts();
        this.fireEvent();
    }

    public BirthmarkSpi getService(String type) {
        BirthmarkSelection elem = this.services.get(type);
        if (elem != null) {
            return elem.getService();
        }
        return null;
    }

    public boolean hasService(String type) {
        return this.services.get(type) != null;
    }

    public void serviceRemoved(BirthmarkSpi service) {
        BirthmarkSelection elem = this.services.get(service);
        if (elem != null) {
            this.model.removeElement(elem);
            this.selectedServices.remove(service);
            this.services.remove(service);
        }
        this.fireEvent();
    }

    private void fireEvent() {
        for (DataChangeListener listener : this.listeners) {
            listener.valueChanged(this);
        }
    }

    private void updateLayouts() {
        this.model.removeAllElements();
        for (String key : this.services.keySet()) {
            BirthmarkSelection elem = this.services.get(key);
            if (elem.isVisible(this.isExpertMode())) {
                this.model.addElement(elem);
            }
            if (elem.isVisible(this.isExpertMode()) && elem.isSelected()) {
                this.selectedServices.add(elem.getType());
                continue;
            }
            this.selectedServices.remove(elem.getType());
        }
        this.updateUI();
    }

    private void initServices() {
        BirthmarkSpi[] serviceArray = this.stigmata.getContext().getServices();
        this.services = new LinkedHashMap<String, BirthmarkSelection>();
        for (BirthmarkSpi service : serviceArray) {
            BirthmarkSelection elem = new BirthmarkSelection(service);
            this.services.put(service.getType(), elem);
        }
    }

    public class BirthmarkSelectionRendererPane
    extends JCheckBox
    implements ListCellRenderer {
        private static final long serialVersionUID = -324432943654654L;

        public BirthmarkSelectionRendererPane() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean forcus) {
            BirthmarkSelection elem = (BirthmarkSelection)value;
            this.setText(elem.getService().getDisplayType());
            this.setToolTipText(elem.getService().getDescription());
            this.setSelected(elem.isSelected());
            this.setBackground(isSelected ? SystemColor.textHighlight : Color.white);
            this.setForeground(isSelected ? SystemColor.textHighlightText : Color.black);
            return this;
        }
    }
}

