/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.filter;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.spi.ServiceRegistry;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jp.naist.se.stigmata.ComparisonPairFilter;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import jp.naist.se.stigmata.spi.ComparisonPairFilterSpi;
import jp.naist.se.stigmata.ui.swing.BirthmarkServiceListener;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.Utility;
import jp.naist.se.stigmata.ui.swing.filter.ComparisonPairFilterComponentService;
import jp.naist.se.stigmata.ui.swing.filter.ComparisonPairFilterListener;
import jp.naist.se.stigmata.ui.swing.filter.ComparisonPairFilterPane;

public class FilterEditingPane
extends JPanel {
    private static final long serialVersionUID = -2607954525579006086L;
    private StigmataFrame stigmata;
    private ComparisonPairFilter filter;
    private JPanel cardComponent;
    private CardLayout card;
    private JComboBox combo;
    private JButton addButton;
    private JButton updateButton;
    private JButton removeButton;
    private ComparisonPairFilterPane currentPane = null;
    private Map<String, ComparisonPairFilterPane> paneMap = new HashMap<String, ComparisonPairFilterPane>();
    private List<ComparisonPairFilterListener> listeners = new ArrayList<ComparisonPairFilterListener>();

    public FilterEditingPane(StigmataFrame stigmata) {
        this.stigmata = stigmata;
        this.initLayouts();
        this.initData();
        this.updateButtonEnabled();
    }

    public void reset() {
        this.initData();
    }

    public void addComparisonPairFilterListener(ComparisonPairFilterListener listener) {
        this.listeners.add(listener);
    }

    public void removeComparisonPairFilterListener(ComparisonPairFilterListener listener) {
        this.listeners.remove(listener);
    }

    public void setFilter(ComparisonPairFilter filter) {
        this.resetOldComponent();
        this.filter = filter;
        if (filter != null && filter.getService() != null) {
            ComparisonPairFilterSpi service = filter.getService();
            String name = service.getDisplayFilterName();
            this.combo.setSelectedItem(name);
            this.card.show(this.cardComponent, name);
            this.paneMap.get(name).setFilter(filter);
        }
        this.updateButtonEnabled();
    }

    private void resetOldComponent() {
        if (this.filter != null) {
            this.paneMap.get(this.filter.getService().getDisplayFilterName()).resetComponents();
        }
    }

    private void updateButtonEnabled() {
        this.addButton.setEnabled(this.currentPane != null);
        this.removeButton.setEnabled(this.filter != null);
        this.updateButton.setEnabled(this.filter != null);
    }

    private void initData() {
        this.cardComponent.removeAll();
        this.combo.removeAllItems();
        this.paneMap.clear();
        JPanel dummyPanel = new JPanel();
        this.card.addLayoutComponent(dummyPanel, "");
        this.cardComponent.add((Component)dummyPanel, "");
        this.combo.addItem("");
        Iterator<ComparisonPairFilterComponentService> i = ServiceRegistry.lookupProviders(ComparisonPairFilterComponentService.class);
        while (i.hasNext()) {
            ComparisonPairFilterComponentService service = i.next();
            String name = service.getDisplayFilterName();
            ComparisonPairFilterPane pane = service.createComponent(service.getComparisonPairFilterService());
            if (pane instanceof BirthmarkServiceListener) {
                for (BirthmarkSpi bs : this.stigmata.getContext().getServices()) {
                    ((BirthmarkServiceListener)((Object)pane)).serviceAdded(bs);
                }
                this.stigmata.addBirthmarkServiceListener((BirthmarkServiceListener)((Object)pane));
            }
            pane.setMaximumSize(new Dimension(Integer.MAX_VALUE, 500));
            Box b = Box.createVerticalBox();
            b.add(pane);
            b.add(Box.createVerticalGlue());
            this.combo.addItem(name);
            this.card.addLayoutComponent(b, name);
            this.cardComponent.add((Component)b, name);
            this.paneMap.put(name, pane);
        }
    }

    private void initLayouts() {
        this.cardComponent = new JPanel();
        this.combo = new JComboBox();
        this.addButton = Utility.createButton("newfilter");
        this.removeButton = Utility.createButton("removefilter");
        this.updateButton = Utility.createButton("updatefilter");
        this.combo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String item = (String)FilterEditingPane.this.combo.getSelectedItem();
                FilterEditingPane.this.card.show(FilterEditingPane.this.cardComponent, item);
                if (FilterEditingPane.this.paneMap.get(item) != null) {
                    if (FilterEditingPane.this.filter != null) {
                        String oldType = FilterEditingPane.this.filter.getService().getDisplayFilterName();
                        if (item.equals(oldType)) {
                            ((ComparisonPairFilterPane)FilterEditingPane.this.paneMap.get(item)).setFilter(FilterEditingPane.this.filter);
                        } else {
                            FilterEditingPane.this.currentPane.resetComponents();
                        }
                    }
                    FilterEditingPane.this.currentPane = (ComparisonPairFilterPane)FilterEditingPane.this.paneMap.get(item);
                } else {
                    FilterEditingPane.this.currentPane = null;
                }
                FilterEditingPane.this.updateButtonEnabled();
            }
        });
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                ComparisonPairFilter newfilter = FilterEditingPane.this.currentPane.getFilter();
                if (newfilter != null) {
                    for (ComparisonPairFilterListener listener : FilterEditingPane.this.listeners) {
                        if (command.equals("updatefilter")) {
                            listener.filterUpdated(FilterEditingPane.this.filter, newfilter);
                            continue;
                        }
                        listener.filterAdded(newfilter);
                    }
                } else {
                    FilterEditingPane.this.showErrorMessage(FilterEditingPane.this.currentPane.getErrors());
                }
            }
        };
        this.addButton.addActionListener(listener);
        this.updateButton.addActionListener(listener);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (ComparisonPairFilterListener listener : FilterEditingPane.this.listeners) {
                    listener.filterRemoved(FilterEditingPane.this.filter);
                }
            }
        });
        Box south = Box.createHorizontalBox();
        south.add(Box.createHorizontalGlue());
        south.add(this.addButton);
        south.add(Box.createHorizontalGlue());
        south.add(this.updateButton);
        south.add(Box.createHorizontalGlue());
        south.add(this.removeButton);
        south.add(Box.createHorizontalGlue());
        this.card = new CardLayout();
        this.cardComponent.setLayout(this.card);
        this.cardComponent.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.cardComponent.getMaximumSize().height));
        Box center = Box.createVerticalBox();
        center.add(this.cardComponent);
        center.add(Box.createVerticalGlue());
        this.setLayout(new BorderLayout());
        this.add((Component)this.combo, "North");
        this.add((Component)center, "Center");
        this.add((Component)south, "South");
    }

    private void showErrorMessage(String[] messages) {
        StringBuilder sb = new StringBuilder("<html><body>");
        sb.append("<p>").append(Messages.getString("error.filter.cannotcreate")).append("</p>");
        sb.append("<ul>");
        for (int i = 0; i < messages.length; ++i) {
            sb.append("<li>").append(messages[i]).append("</li>");
        }
        sb.append("</ul></body></html>");
        JOptionPane.showMessageDialog(this.stigmata, new String(sb), Messages.getString("error.dialog.title"), 0);
    }
}

