/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks.comparators;

import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkComparator;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.spi.BirthmarkSpi;

public class DPMatchingBirthmarkComparator
implements BirthmarkComparator {
    private BirthmarkSpi spi;
    private int mismatchPenalty = 5;
    private int shiftPenalty = 1;

    public DPMatchingBirthmarkComparator() {
    }

    public DPMatchingBirthmarkComparator(BirthmarkSpi spi) {
        this.spi = spi;
    }

    public BirthmarkSpi getProvider() {
        return this.spi;
    }

    public String getType() {
        return this.spi.getType();
    }

    public int getMismatchPenalty() {
        return this.mismatchPenalty;
    }

    public void setMismatchPenalty(int mismatchPenalty) {
        this.mismatchPenalty = mismatchPenalty;
    }

    public int getShiftPenalty() {
        return this.shiftPenalty;
    }

    public void setShiftPenalty(int shiftPenalty) {
        this.shiftPenalty = shiftPenalty;
    }

    public double compare(Birthmark b1, Birthmark b2) {
        if (!b1.getType().equals(b2.getType())) {
            return Double.NaN;
        }
        BirthmarkElement[] element1 = b1.getElements();
        BirthmarkElement[] element2 = b2.getElements();
        if (element1.length > 0 && element2.length > 0) {
            int[][] cost = this.createCostMatrics(element1, element2);
            int max = (element1.length + element2.length) * (this.getMismatchPenalty() + this.getShiftPenalty());
            int distance = cost[element1.length - 1][element2.length - 1];
            return (double)(max - distance) / (double)max;
        }
        if (element1.length == 0 && element2.length == 0) {
            return 1.0;
        }
        return 0.0;
    }

    public int getCompareCount(Birthmark b1, Birthmark b2) {
        return b1.getElementCount() + b2.getElementCount();
    }

    private int[][] createCostMatrics(BirthmarkElement[] targetX, BirthmarkElement[] targetY) {
        int i;
        int[][] mismatches = this.getMismatchMatrics(targetX, targetY);
        int[][] cost = new int[targetX.length][targetY.length];
        cost[0][0] = mismatches[0][0] * this.getMismatchPenalty();
        for (i = 1; i < targetX.length; ++i) {
            cost[i][0] = cost[i - 1][0] + this.getShiftPenalty() + mismatches[i][0] * this.getMismatchPenalty();
        }
        for (i = 1; i < targetY.length; ++i) {
            cost[0][i] = cost[0][i - 1] + this.getShiftPenalty() + mismatches[0][i] * this.getMismatchPenalty();
        }
        for (i = 1; i < targetX.length; ++i) {
            for (int j = 1; j < targetY.length; ++j) {
                int crossCost = cost[i - 1][j - 1] + mismatches[i][j] * this.getMismatchPenalty();
                int horizontalCost = cost[i - 1][j] + mismatches[i][j] * this.getMismatchPenalty() + this.getShiftPenalty();
                int verticalCost = cost[i][j - 1] + mismatches[i][j] * this.getMismatchPenalty() + this.getShiftPenalty();
                cost[i][j] = crossCost <= horizontalCost && crossCost <= verticalCost ? crossCost : (horizontalCost <= verticalCost ? horizontalCost : verticalCost);
            }
        }
        return cost;
    }

    private int[][] getMismatchMatrics(BirthmarkElement[] targetX, BirthmarkElement[] targetY) {
        int[][] mismatches = new int[targetX.length][targetY.length];
        for (int i = 0; i < mismatches.length; ++i) {
            for (int j = 0; j < mismatches[i].length; ++j) {
                if (targetX[i] == null) {
                    if (targetY[j] == null) {
                        mismatches[i][j] = 0;
                        continue;
                    }
                    mismatches[i][j] = 1;
                    continue;
                }
                mismatches[i][j] = targetX[i].equals(targetY[j]) ? 0 : 1;
            }
        }
        return mismatches;
    }
}

