/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import jp.naist.se.stigmata.ui.swing.CurrentDirectoryHolder;
import jp.naist.se.stigmata.ui.swing.DataChangeListener;
import jp.naist.se.stigmata.ui.swing.ExtensionFilter;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.Utility;

public class TargetSelectionPane
extends JPanel {
    private static final long serialVersionUID = 3209435745432235432L;
    private CurrentDirectoryHolder currentDirectoryHolder;
    private FileFilter filter;
    private List<String> extensions = new ArrayList<String>();
    private String description;
    private DefaultListModel model = new DefaultListModel();
    private List<DataChangeListener> listeners = new ArrayList<DataChangeListener>();
    private boolean directorySelectable = false;
    private boolean multipleSelectable = true;
    private JList list;
    private JButton addButton;
    private JButton removeButton;

    public TargetSelectionPane(CurrentDirectoryHolder cdh) {
        this.currentDirectoryHolder = cdh;
        this.initComponents();
        this.list.setModel(this.model);
        TargetSelectionDropTarget dropTarget = new TargetSelectionDropTarget();
        this.list.setDropTarget(dropTarget);
    }

    public void addDataChangeListener(DataChangeListener listener) {
        this.listeners.add(listener);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void removeAllElements() {
        this.model.removeAllElements();
        this.fireEvent();
    }

    public void setFileFilter(FileFilter filter) {
        this.filter = filter;
    }

    public FileFilter getFileFilter() {
        if (this.filter == null) {
            this.filter = new ExtensionFilter(this.getExtensions(), this.getSelectDescription());
        }
        return this.filter;
    }

    public void addTargetExtension(String ext) {
        if (this.filter instanceof ExtensionFilter) {
            this.filter = null;
        }
        this.extensions.add(ext);
    }

    public void addTargetExtensions(String[] exts) {
        if (this.filter instanceof ExtensionFilter) {
            this.filter = null;
        }
        for (String ext : exts) {
            this.extensions.add(ext);
        }
    }

    public synchronized String[] getExtensions() {
        return this.extensions.toArray(new String[this.extensions.size()]);
    }

    public void setSelectDescription(String description) {
        this.description = description;
    }

    public String getSelectDescription() {
        return this.description;
    }

    public String[] getValues() {
        String[] strings = new String[this.model.getSize()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = (String)this.model.getElementAt(i);
        }
        return strings;
    }

    public String[] getSelectedValues() {
        int[] indeces = this.list.getSelectedIndices();
        String[] strings = new String[indeces.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = (String)this.model.getElementAt(indeces[i]);
        }
        return strings;
    }

    public void addValues(String[] values) {
        for (String value : values) {
            this.addValue(value);
        }
    }

    public void addValue(String value) {
        this.model.addElement(value);
        this.fireEvent();
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.addButton.setEnabled(flag);
        this.removeButton.setEnabled(flag);
        this.list.setEnabled(flag);
    }

    public void setDirectorySelectable(boolean flag) {
        this.directorySelectable = flag;
    }

    public boolean isDirectorySelectable() {
        return this.directorySelectable;
    }

    public void setMultipleSelectable(boolean flag) {
        this.multipleSelectable = flag;
    }

    public boolean isMultipleSelectable() {
        return this.multipleSelectable;
    }

    private void fireEvent() {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            DataChangeListener listener = this.listeners.get(i);
            listener.valueChanged(this.model);
        }
    }

    private void initComponents() {
        JScrollPane scroll = new JScrollPane();
        Box south = Box.createHorizontalBox();
        this.list = new JList();
        this.addButton = Utility.createButton("addpackage");
        this.removeButton = Utility.createButton("removepackage");
        this.removeButton.setEnabled(false);
        this.setLayout(new BorderLayout());
        scroll.setViewportView(this.list);
        this.add((Component)scroll, "Center");
        south.add(Box.createHorizontalGlue());
        south.add(this.addButton);
        south.add(Box.createHorizontalGlue());
        south.add(this.removeButton);
        south.add(Box.createHorizontalGlue());
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                TargetSelectionPane.this.listValueChanged(evt);
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TargetSelectionPane.this.addButtonActionPerformed(evt);
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TargetSelectionPane.this.removeButtonActionPerformed(evt);
            }
        });
        this.add((Component)south, "South");
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int[] indeces = this.list.getSelectedIndices();
        if (indeces != null && indeces.length >= 1) {
            for (int i = indeces.length - 1; i >= 0; --i) {
                this.model.removeElementAt(indeces[i]);
                this.fireEvent();
            }
        }
        this.removeButton.setEnabled(false);
    }

    private void listValueChanged(ListSelectionEvent evt) {
        int[] indeces = this.list.getSelectedIndices();
        this.removeButton.setEnabled(this.isEnabled() && indeces != null);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        int returnCode;
        JFileChooser chooser = new JFileChooser(this.currentDirectoryHolder.getCurrentDirectory());
        FileFilter filter = this.getFileFilter();
        if (filter == null) {
            filter = new ExtensionFilter(this.getExtensions(), this.getSelectDescription());
        }
        chooser.setFileFilter(filter);
        chooser.setMultiSelectionEnabled(this.isMultipleSelectable());
        if (this.isDirectorySelectable()) {
            chooser.setFileSelectionMode(2);
        }
        if ((returnCode = chooser.showOpenDialog(SwingUtilities.getRootPane(this))) == 0) {
            File[] files;
            this.currentDirectoryHolder.setCurrentDirectory(chooser.getCurrentDirectory());
            for (File file : files = chooser.getSelectedFiles()) {
                this.addValue(file.getPath());
            }
        }
    }

    private class TargetSelectionDropTarget
    extends DropTarget {
        private static final long serialVersionUID = 3204457621345L;

        private TargetSelectionDropTarget() {
        }

        public void dragEnter(DropTargetDragEvent arg0) {
        }

        public void dragExit(DropTargetEvent arg0) {
        }

        public void dragOver(DropTargetDragEvent arg0) {
        }

        public void dropActionChanged(DropTargetDragEvent arg0) {
        }

        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(0x40000000);
            Transferable trans = dtde.getTransferable();
            try {
                if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List list = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                    TargetSelectionPane.this.filter = TargetSelectionPane.this.getFileFilter();
                    ArrayList<String> errorList = new ArrayList<String>();
                    for (int i = 0; i < list.size(); ++i) {
                        File file = (File)list.get(i);
                        if (TargetSelectionPane.this.filter.accept(file)) {
                            TargetSelectionPane.this.addValue(file.getPath());
                            continue;
                        }
                        errorList.add(file.getName());
                    }
                    if (errorList.size() > 0) {
                        StringBuilder builder = new StringBuilder("<html><body>");
                        builder.append(Messages.getString("unsupportedfiletype.dialog.message"));
                        builder.append("<ul>");
                        for (int i = 0; i < errorList.size(); ++i) {
                            builder.append("<li>").append((String)errorList.get(i)).append("</li>");
                        }
                        builder.append("</ul></body></html>");
                        JOptionPane.showMessageDialog(TargetSelectionPane.this, new String(builder), Messages.getString("unsupportedfiletype.dialog.title"), 0);
                    }
                }
            }
            catch (UnsupportedFlavorException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

