/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.naist.se.stigmata.ComparisonPairFilter;
import jp.naist.se.stigmata.ComparisonPairFilterSet;
import jp.naist.se.stigmata.filter.ComparisonPairFilterManager;
import jp.naist.se.stigmata.ui.swing.filter.ComparisonPairFilterRetainable;
import jp.naist.se.stigmata.ui.swing.filter.FilterSetDefinitionPane;

public class FilterSelectionPane
extends JPanel
implements ComparisonPairFilterRetainable {
    private static final long serialVersionUID = 1825547576389498336L;
    private static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private ComparisonPairFilterManager manager;
    private FilterSetDefinitionPane filterDef;
    private Map<String, Boolean> enableMap = new HashMap<String, Boolean>();
    private Map<String, ComparisonPairFilterSet> filters = new HashMap<String, ComparisonPairFilterSet>();
    private DefaultListModel model;
    private JList list;

    public FilterSelectionPane(ComparisonPairFilterManager manager) {
        this.manager = manager;
        this.initLayout();
    }

    public void addFilterSet(ComparisonPairFilterSet filter) {
        this.filters.put(filter.getName(), filter);
        this.enableMap.put(filter.getName(), false);
        this.model.addElement(filter.getName());
    }

    public void filterSelected(ComparisonPairFilter filter) {
    }

    public ComparisonPairFilterSet getFilterSet(String name) {
        return this.filters.get(name);
    }

    public void removeFilterSet(String name) {
        this.filters.remove(name);
        this.enableMap.remove(name);
        this.model.removeElement(name);
    }

    public void updateFilterSet(String name, ComparisonPairFilterSet filter) {
        int index = this.model.indexOf(name);
        this.model.set(index, filter.getName());
        this.filters.put(filter.getName(), filter);
        this.enableMap.put(filter.getName(), this.enableMap.get(name));
        if (!name.equals(filter.getName())) {
            this.enableMap.remove(name);
            this.filters.remove(name);
        }
    }

    public String[] getSelectedFilters() {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.enableMap.keySet()) {
            if (!this.enableMap.get(key).booleanValue()) continue;
            list.add(key);
        }
        return list.toArray(new String[list.size()]);
    }

    private void initLayout() {
        this.setLayout(new BorderLayout());
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new CheckableListCellRenderer());
        JScrollPane scroll = new JScrollPane(this.list);
        this.filterDef = new FilterSetDefinitionPane(this, false);
        this.add((Component)scroll, "West");
        this.add((Component)this.filterDef, "Center");
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                String name = (String)FilterSelectionPane.this.list.getSelectedValue();
                FilterSelectionPane.this.filterDef.setFilterSet((ComparisonPairFilterSet)FilterSelectionPane.this.filters.get(name));
                FilterSelectionPane.this.updateUI();
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int index = FilterSelectionPane.this.list.locationToIndex(e.getPoint());
                String value = (String)FilterSelectionPane.this.model.getElementAt(index);
                FilterSelectionPane.this.enableMap.put(value, (Boolean)FilterSelectionPane.this.enableMap.get(value) == false);
                FilterSelectionPane.this.updateUI();
            }
        });
        ComparisonPairFilterSet[] comparisonPairFilterSetArray = this.manager.getFilterSets();
        int n = 0;
        int n2 = comparisonPairFilterSetArray.length;
        while (n < n2) {
            ComparisonPairFilterSet filterset = comparisonPairFilterSetArray[n];
            this.enableMap.put(filterset.getName(), false);
            this.filters.put(filterset.getName(), filterset);
            this.model.addElement(filterset.getName());
            ++n;
        }
    }

    private class CheckableListCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        private static final long serialVersionUID = 2120743754620361163L;

        public CheckableListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object v, int index, boolean isSelected, boolean cellHasFocus) {
            String value = (String)v;
            this.setText(value);
            this.setSelected((Boolean)FilterSelectionPane.this.enableMap.get(value));
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            Border border = null;
            if (cellHasFocus) {
                if (isSelected) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                border = noFocusBorder;
            }
            this.setBorder(border);
            return this;
        }
    }
}

