/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkElementClassNotFoundException;
import jp.naist.se.stigmata.BirthmarkExtractionException;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.CertainPairComparisonResultSet;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ComparisonPairFilterSet;
import jp.naist.se.stigmata.ComparisonResultSet;
import jp.naist.se.stigmata.Stigmata;
import jp.naist.se.stigmata.filter.FilteredComparisonResultSet;
import jp.naist.se.stigmata.ui.swing.BirthmarkExtractionResultPane;
import jp.naist.se.stigmata.ui.swing.BirthmarkServiceListener;
import jp.naist.se.stigmata.ui.swing.ControlPane;
import jp.naist.se.stigmata.ui.swing.CurrentDirectoryHolder;
import jp.naist.se.stigmata.ui.swing.FileIOManager;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.PairComparisonPane;
import jp.naist.se.stigmata.ui.swing.PairComparisonResultSetPane;
import jp.naist.se.stigmata.ui.swing.RoundRobinComparisonResultPane;
import jp.naist.se.stigmata.ui.swing.Utility;
import jp.naist.se.stigmata.ui.swing.actions.AboutAction;
import jp.naist.se.stigmata.ui.swing.actions.LicenseAction;
import jp.naist.se.stigmata.ui.swing.graph.SimilarityDistributionGraphPane;
import jp.naist.se.stigmata.ui.swing.mds.MDSGraphPanel;
import jp.naist.se.stigmata.ui.swing.tab.EditableTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StigmataFrame
extends JFrame
implements CurrentDirectoryHolder {
    private static final long serialVersionUID = 92345543665342134L;
    private static List<JFrame> frameList = new ArrayList<JFrame>();
    private JTabbedPane tabPane;
    private JMenuItem closeTabMenu;
    private JCheckBoxMenuItem expertmodeMenu;
    private Stigmata stigmata;
    private BirthmarkContext context;
    private ControlPane control;
    private FileIOManager fileio;
    private int extractCount = 0;
    private int compareCount = 0;
    private int compareDetail = 0;
    private int similarityGraphCount = 0;
    private int mappingGraphCount = 0;
    private int comparePair = 0;

    public StigmataFrame() {
        this.stigmata = Stigmata.getInstance();
        this.context = this.stigmata.createContext();
        this.fileio = new FileIOManager(this);
        this.initLayouts();
    }

    public StigmataFrame(Stigmata stigmata) {
        this(stigmata, stigmata.createContext());
    }

    public StigmataFrame(Stigmata stigmata, BirthmarkContext context) {
        this.stigmata = stigmata;
        this.context = context;
        this.fileio = new FileIOManager(this);
        this.initLayouts();
    }

    public Stigmata getStigmata() {
        return this.stigmata;
    }

    public BirthmarkContext getContext() {
        return this.context;
    }

    @Override
    public File getCurrentDirectory() {
        return this.fileio.getCurrentDirectory();
    }

    @Override
    public void setCurrentDirectory(File file) {
        this.fileio.setCurrentDirectory(file);
    }

    public File getOpenFile(String[] exts, String desc) {
        return this.fileio.findFile(true, exts, desc);
    }

    public File getSaveFile(String[] exts, String desc) {
        return this.fileio.findFile(false, exts, desc);
    }

    public void addBirthmarkServiceListener(BirthmarkServiceListener listener) {
        this.control.addBirthmarkServiceListener(listener);
    }

    public void removeBirthmarkServiceListener(BirthmarkServiceListener listener) {
        this.control.removeBirthmarkServiceListener(listener);
    }

    public void compareDetails(BirthmarkSet target1, BirthmarkSet target2, BirthmarkContext context) {
        PairComparisonPane detail = new PairComparisonPane(this, new ComparisonPair(target1, target2, context));
        ++this.compareDetail;
        Utility.addNewTab("comparedetail", this.tabPane, detail, new Object[]{new Integer(this.compareDetail)}, new Object[]{Utility.array2String(target1.getBirthmarkTypes()), target1.getName(), target2.getName()});
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
    }

    public void compareRoundRobin(String[] birthmarks, String[] targetX, String[] targetY, BirthmarkContext context) {
        try {
            BirthmarkSet[] x = this.stigmata.extract(birthmarks, targetX, context);
            BirthmarkSet[] y = this.stigmata.extract(birthmarks, targetY, context);
            RoundRobinComparisonResultPane compare = new RoundRobinComparisonResultPane(this, context, x, y);
            ++this.compareCount;
            Utility.addNewTab("compare", this.tabPane, compare, new Object[]{new Integer(this.compareCount)}, new Object[]{Utility.array2String(birthmarks), Utility.array2String(targetX), Utility.array2String(targetY)});
            this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
    }

    public void compareRoundRobin(String[] birthmarks, String[] targetX, String[] targetY, String[] filterNames, BirthmarkContext context) {
        try {
            BirthmarkSet[] x = this.stigmata.extract(birthmarks, targetX, context);
            BirthmarkSet[] y = this.stigmata.extract(birthmarks, targetY, context);
            ComparisonPairFilterSet[] filters = context.getFilterManager().getFilterSets(filterNames);
            ComparisonResultSet resultset = this.stigmata.compare(x, y, context);
            FilteredComparisonResultSet fcrs = new FilteredComparisonResultSet(resultset, filters);
            ++this.compareCount;
            Utility.addNewTab("compare", this.tabPane, new PairComparisonResultSetPane(this, fcrs), new Object[]{new Integer(this.compareCount)}, new Object[]{Utility.array2String(birthmarks), Utility.array2String(targetX), Utility.array2String(targetY)});
            this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
    }

    public void compareGuessedPair(String[] birthmarks, String[] targetX, String[] targetY, BirthmarkContext context) {
        try {
            BirthmarkSet[] x = this.stigmata.extract(birthmarks, targetX, context);
            BirthmarkSet[] y = this.stigmata.extract(birthmarks, targetY, context);
            ++this.comparePair;
            CertainPairComparisonResultSet resultset = new CertainPairComparisonResultSet(x, y, context);
            Utility.addNewTab("comparepair", this.tabPane, new PairComparisonResultSetPane(this, resultset), new Object[]{new Integer(this.comparePair)}, new Object[]{Utility.array2String(birthmarks), Utility.array2String(targetX), Utility.array2String(targetY)});
            this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
    }

    public void compareSpecifiedPair(String[] birthmarks, String[] targetX, String[] targetY, BirthmarkContext context) {
        File file = this.getOpenFile(Messages.getStringArray("comparemapping.extension"), Messages.getString("comparemapping.description"));
        if (file != null) {
            Map<String, String> mapping = this.constructMapping(file);
            try {
                BirthmarkSet[] x = this.stigmata.extract(birthmarks, targetX, context);
                BirthmarkSet[] y = this.stigmata.extract(birthmarks, targetY, context);
                ++this.comparePair;
                CertainPairComparisonResultSet resultset = new CertainPairComparisonResultSet(x, y, mapping, context);
                Utility.addNewTab("comparepair", this.tabPane, new PairComparisonResultSetPane(this, resultset), new Object[]{new Integer(this.comparePair)}, new Object[]{Utility.array2String(birthmarks), Utility.array2String(targetX), Utility.array2String(targetY)});
                this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
            }
            catch (Exception e) {
                this.showExceptionMessage(e);
            }
        }
    }

    public void showComparisonResultSet(ComparisonResultSet resultset) {
        ++this.comparePair;
        Utility.addNewTab("comparisonresultset", this.tabPane, new PairComparisonResultSetPane(this, resultset), new Object[]{new Integer(this.comparePair)}, null);
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
    }

    public void showMDSGraph(BirthmarkSet[] set) {
        MDSGraphPanel panel = new MDSGraphPanel(this, set, this.context);
        ++this.mappingGraphCount;
        Utility.addNewTab("mappinggraph", this.tabPane, panel, new Object[]{new Integer(this.mappingGraphCount)}, null);
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
    }

    public void showSimilarityDistributionGraph(Map<Integer, Integer> distributions) {
        SimilarityDistributionGraphPane graph = new SimilarityDistributionGraphPane(this, distributions);
        ++this.similarityGraphCount;
        Utility.addNewTab("similaritygraph", this.tabPane, graph, new Object[]{new Integer(this.similarityGraphCount)}, null);
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
    }

    public void showExtractionResult(BirthmarkSet[] set, BirthmarkContext context) {
        ++this.extractCount;
        BirthmarkExtractionResultPane viewer = new BirthmarkExtractionResultPane(this, context, set);
        Utility.addNewTab("extract", this.tabPane, viewer, new Object[]{new Integer(this.extractCount)}, new Object[]{Utility.array2String(set[0].getBirthmarkTypes())});
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
    }

    public void extract(String[] birthmarks, String[] targets, BirthmarkContext context) {
        try {
            BirthmarkSet[] holders = this.stigmata.extract(birthmarks, targets, context);
            this.showExtractionResult(holders, context);
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
    }

    public Map<String, String> constructMapping(File file) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        BufferedReader in = null;
        try {
            try {
                String line;
                in = new BufferedReader(new FileReader(file));
                while ((line = in.readLine()) != null) {
                    String[] tokens = line.split(", *");
                    if (tokens.length < 2) continue;
                    mapping.put(tokens[0], tokens[1]);
                }
            }
            catch (Exception e) {
                this.showExceptionMessage(e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return mapping;
    }

    private void initLayouts() {
        this.setTitle(Messages.getString("stigmata.frame.title"));
        this.initComponents();
        this.control = new ControlPane(this);
        Utility.addNewTab("control", this.tabPane, this.control, null, null);
        this.control.inititalize();
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
        this.setSize(900, 600);
        frameList.add(this);
    }

    private void initComponents() {
        JMenuBar menubar = new JMenuBar();
        menubar.add(this.createFileMenu());
        menubar.add(this.createHelpMenu());
        this.setJMenuBar(menubar);
        this.tabPane = new EditableTabbedPane(this);
        this.add((Component)this.tabPane, "Center");
        this.tabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                String title = StigmataFrame.this.tabPane.getTitleAt(StigmataFrame.this.tabPane.getSelectedIndex());
                StigmataFrame.this.closeTabMenu.setEnabled(!title.equals(Messages.getString("control.tab.label")));
            }
        });
        this.setDefaultCloseOperation(2);
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = Utility.createJMenu("fileMenu");
        JMenuItem newFrameMenu = Utility.createJMenuItem("newframe");
        JMenuItem exportMenu = Utility.createJMenuItem("exportsetting");
        JMenuItem closeTabMenu = Utility.createJMenuItem("closetab");
        JMenuItem closeMenu = Utility.createJMenuItem("closeframe");
        JMenuItem exitMenu = Utility.createJMenuItem("exit");
        this.closeTabMenu = closeTabMenu;
        fileMenu.add(newFrameMenu);
        fileMenu.add(new JSeparator());
        fileMenu.add(exportMenu);
        fileMenu.add(new JSeparator());
        fileMenu.add(closeTabMenu);
        fileMenu.add(closeMenu);
        fileMenu.add(new JSeparator());
        fileMenu.add(exitMenu);
        newFrameMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StigmataFrame.this.newFrameMenuActionPerformed(evt);
            }
        });
        exportMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StigmataFrame.this.control.exportSettings();
            }
        });
        closeTabMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StigmataFrame.this.closeTabMenuActionPerformed();
            }
        });
        closeMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StigmataFrame.this.closeMenuActionPerformed(evt);
            }
        });
        exitMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        });
        return fileMenu;
    }

    private JMenu createHelpMenu() {
        JMenu menu = Utility.createJMenu("helpmenu");
        JMenuItem about = Utility.createJMenuItem("about", new AboutAction(this));
        JMenuItem license = Utility.createJMenuItem("license", new LicenseAction(this));
        JMenuItem help = Utility.createJMenuItem("helpmenu");
        JMenu laf = Utility.createJMenu("lookandfeel");
        this.expertmodeMenu = Utility.createJCheckBoxMenuItem("expertmenu");
        menu.add(about);
        menu.add(license);
        menu.add(help);
        menu.add(new JSeparator());
        menu.add(laf);
        menu.add(new JSeparator());
        menu.add(this.expertmodeMenu);
        this.expertmodeMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StigmataFrame.this.expertMenuActionPerformed(((JCheckBoxMenuItem)e.getSource()).getState());
            }
        });
        final UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        int i = 0;
        while (i < info.length) {
            final int index = i;
            JMenuItem item = new JMenuItem(info[i].getName());
            laf.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        UIManager.setLookAndFeel(info[index].getClassName());
                        SwingUtilities.updateComponentTreeUI(StigmataFrame.this);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            ++i;
        }
        help.setEnabled(false);
        return menu;
    }

    public void setExpertMode(boolean expertmode) {
        this.expertmodeMenu.setState(expertmode);
    }

    private void expertMenuActionPerformed(boolean status) {
        this.control.setExpertMode(status);
    }

    private void showExceptionMessage(Exception e) {
        if (e instanceof BirthmarkElementClassNotFoundException) {
            this.showClassNotFoundMessage((BirthmarkElementClassNotFoundException)e);
            return;
        }
        JTextArea area = new JTextArea(20, 60);
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        e.printStackTrace(out);
        if (e instanceof BirthmarkExtractionException) {
            out.println("Causes:");
            Throwable[] throwableArray = ((BirthmarkExtractionException)e).getCauses();
            int n = 0;
            int n2 = throwableArray.length;
            while (n < n2) {
                Throwable t = throwableArray[n];
                t.printStackTrace(out);
                ++n;
            }
        }
        out.close();
        area.setText(writer.toString());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(Messages.getString("error.message.contactus")), "North");
        panel.add((Component)new JScrollPane(area), "Center");
        JOptionPane.showMessageDialog(this, panel, Messages.getString("error.dialog.title"), 2);
    }

    private void showClassNotFoundMessage(BirthmarkElementClassNotFoundException e) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><body><p>");
        sb.append(Messages.getString("error.message.classpath"));
        sb.append("</p><ul>");
        String[] stringArray = e.getClassNames();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String name = stringArray[n];
            sb.append("<li>").append(name).append("</li>");
            ++n;
        }
        sb.append("</ul></body></html>");
        JOptionPane.showMessageDialog(this, new String(sb), Messages.getString("error.dialog.title"), 2);
    }

    private void closeTabMenuActionPerformed() {
        int index = this.tabPane.getSelectedIndex();
        if (index == 0) {
            JOptionPane.showMessageDialog(this, Messages.getString("cannotclosecontroltab.dialog.message"), Messages.getString("cannotclosecontroltab.dialog.title"), 0);
        } else {
            this.tabPane.removeTabAt(index);
        }
    }

    private void closeMenuActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
        frameList.remove(this);
        if (frameList.size() == 0) {
            System.exit(1);
        }
    }

    private void newFrameMenuActionPerformed(ActionEvent evt) {
        StigmataFrame frame = new StigmataFrame(this.stigmata, this.context);
        frame.setVisible(true);
    }
}

