/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ComparisonPairElement;
import jp.naist.se.stigmata.format.FormatManager;
import jp.naist.se.stigmata.spi.ResultFormatSpi;
import jp.naist.se.stigmata.ui.swing.AsciiDataWritable;
import jp.naist.se.stigmata.ui.swing.BirthmarkTreeNode;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.Utility;
import jp.naist.se.stigmata.ui.swing.actions.SaveAction;

public class PairComparisonPane
extends JPanel {
    private static final long serialVersionUID = 2342856785474356234L;
    private StigmataFrame frame;
    private ComparisonPair pair;

    public PairComparisonPane(StigmataFrame frame, ComparisonPair pair) {
        this.frame = frame;
        this.pair = pair;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getSouthPanel(), "South");
        this.add((Component)this.getMainPane(), "Center");
    }

    private JPanel getSouthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel similarityPanel = new JPanel();
        similarityPanel.setLayout(new GridLayout(1, 3));
        JLabel label = new JLabel(Double.toString(this.pair.calculateSimilarity()));
        label.setBorder(BorderFactory.createTitledBorder(Messages.getString("result.border")));
        JComboBox<ComparisonPairElement> combo = new JComboBox<ComparisonPairElement>();
        for (ComparisonPairElement elem : this.pair) {
            combo.addItem(elem);
        }
        combo.setRenderer(new ComparisonPairElementRenderer(new Dimension(100, combo.getPreferredSize().height), 50));
        combo.setBorder(BorderFactory.createTitledBorder(Messages.getString("eachbirthmarksimilarity.border")));
        similarityPanel.add(label);
        similarityPanel.add(combo);
        similarityPanel.setBorder(new TitledBorder(Messages.getString("similarity.border")));
        panel.add(similarityPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton saveButton = Utility.createButton("savecomparison", new SaveAction(this.frame, new AsciiDataWritable(){

            public void writeAsciiData(PrintWriter out, String format) throws IOException {
                ResultFormatSpi service = FormatManager.getInstance().getService(format);
                if (service == null) {
                    service = FormatManager.getDefaultFormatService();
                }
                service.getComparisonResultFormat().printResult(out, PairComparisonPane.this.pair);
            }
        }));
        buttonPanel.add(saveButton);
        panel.add(buttonPanel);
        return panel;
    }

    private JSplitPane getMainPane() {
        JSplitPane spliter = new JSplitPane();
        spliter.setLeftComponent(this.getSpliterPanel(this.pair.getTarget1()));
        spliter.setRightComponent(this.getSpliterPanel(this.pair.getTarget2()));
        spliter.setDividerLocation((spliter.getWidth() - spliter.getDividerSize()) / 2);
        spliter.setContinuousLayout(true);
        return spliter;
    }

    private JPanel getSpliterPanel(BirthmarkSet birthmark) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JTree tree = new JTree(new BirthmarkTreeNode(birthmark));
        panel.add((Component)new JScrollPane(tree), "Center");
        JPanel south = new JPanel(new BorderLayout());
        panel.add((Component)south, "South");
        JLabel elementCount = new JLabel(Integer.toString(birthmark.getSumOfElementCount()));
        elementCount.setBorder(new TitledBorder(Messages.getString("elementcount.border")));
        south.add((Component)elementCount, "Center");
        return panel;
    }

    private static class ComparisonPairElementRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 32943674625674235L;
        private final JLabel left = new JLabel();
        private final JLabel right = new JLabel();

        public ComparisonPairElementRenderer(Dimension dim, int rightWidth) {
            super(new BorderLayout());
            this.setOpaque(true);
            this.left.setOpaque(true);
            this.right.setOpaque(true);
            this.left.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            this.right.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.right.setPreferredSize(new Dimension(rightWidth, 0));
            this.add((Component)this.left, "Center");
            this.add((Component)this.right, "East");
            this.setPreferredSize(dim);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ComparisonPairElement elem = (ComparisonPairElement)value;
            if (elem != null) {
                this.left.setText(elem.getType());
                this.right.setText(Double.toString(elem.getSimilarity()));
            }
            this.setBackground(isSelected ? SystemColor.textHighlight : Color.white);
            this.left.setBackground(isSelected ? SystemColor.textHighlight : Color.white);
            this.right.setBackground(isSelected ? SystemColor.textHighlight : Color.white);
            this.left.setForeground(isSelected ? Color.white : Color.black);
            this.right.setForeground(isSelected ? Color.gray.brighter() : Color.gray);
            return this;
        }
    }
}

