package jp.naist.se.stigmata.birthmarks.is;

/*
 * $Id: InheritanceStructureBirthmarkExtractVisitor.java 130 2007-06-13 10:08:01Z tama3 $
 */

import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.birthmarks.BirthmarkExtractVisitor;
import jp.naist.se.stigmata.birthmarks.NullBirthmarkElement;
import jp.naist.se.stigmata.utils.WellknownClassManager;

import org.objectweb.asm.ClassVisitor;

/**
 * 
 * 
 *
 * @author Haruaki TAMADA
 * @version $Revision: 130 $ $Date: 2007-06-13 19:08:01 +0900 (Wed, 13 Jun 2007) $
 */
public class InheritanceStructureBirthmarkExtractVisitor extends BirthmarkExtractVisitor{
    public InheritanceStructureBirthmarkExtractVisitor(ClassVisitor visitor, Birthmark birthmark, BirthmarkContext context){
        super(visitor, birthmark, context);
    }

    public void visit(int version, int access, String name, String signature,
                      String superName, String[] interfaces){
        try {
            Class c = getContext().getBytecodeContext().findClass(name.replace('/', '.'));
            if(c != null && !c.isInterface()){
                addISBirthmark(c);
            }
        } catch (ClassNotFoundException ex){
            addFailur(ex);
        }
    }

    private void addISBirthmark(Class c){
        WellknownClassManager wcm = getContext().getWellknownClassManager();
        do{
            String className = c.getName();

            if(wcm.isWellKnownClass(className)){
                addElement(new BirthmarkElement(className));
            }
            else{
                addElement(NullBirthmarkElement.getInstance());
            }
            c = c.getSuperclass();
        } while(!c.getName().equals("java.lang.Object"));
        addElement(new BirthmarkElement("java.lang.Object"));
    }
}
