package jp.naist.se.stigmata.printer;

/*
 * $Id: AbstractComparisonPairPrinter.java 243 2007-10-08 01:27:30Z tama3 $
 */

import java.io.PrintWriter;
import java.io.StringWriter;

import jp.naist.se.stigmata.ComparisonPair;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 243 $ $Date: 2007-10-08 10:27:30 +0900 (Mon, 08 Oct 2007) $
 */
public abstract class AbstractComparisonPairPrinter implements ComparisonPairPrinter, Printer{

    public abstract void printResult(PrintWriter out, ComparisonPair pair);

    public void printFooter(PrintWriter out){
        out.flush();
    }

    public void printHeader(PrintWriter out){
    }

    public String getResult(ComparisonPair pair){
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);

        printResult(out, pair);

        out.close();
        return writer.toString();
    }
}
