package jp.naist.se.stigmata.result.history;

/*
 * $Id: ExtractedBirthmarkHistory.java 254 2007-10-26 01:31:44Z tama3 $
 */

import java.util.Iterator;

import jp.naist.se.stigmata.ExtractionResultSet;

/**
 * This interface indicates extracted history management.
 * 
 * @author Haruaki Tamada
 * @version $Revision: 254 $ $Date: 2007-10-26 10:31:44 +0900 (Fri, 26 Oct 2007) $
 */
public interface ExtractedBirthmarkHistory extends Iterable<String>{
    /**
     * returns a list of histor ids as iterator.
     */
    public Iterator<String> iterator();

    /**
     * returns an array of history ids.
     */
    public String[] getResultSetIds();

    /**
     * returns an extraction result set corresponding id.
     */
    public ExtractionResultSet getResultSet(String id);

    /**
     * deletes all histories this instance is managed.
     */
    public void deleteAllResultSets();

    /**
     * deletes an extraction result set corresponding id.
     */
    public void deleteResultSet(String id);

    /**
     * refreshes histories.
     */
    public void refresh();
}
