package jp.naist.se.stigmata.utils;

/*
 * $Id: Names.java 225 2007-10-02 06:22:42Z tama3 $
 */

import java.io.Serializable;

/**
 *
 * @author Haruaki Tamada
 * @version $Revision: 225 $ $Date: 2007-10-02 15:22:42 +0900 (Tue, 02 Oct 2007) $
 */
class Names implements Serializable{
    private static final long serialVersionUID = 1911603124143509407L;
    private final String fullyName;
    private String className;
    private String packageName;

    public Names(final String fullyName){
        this.fullyName = fullyName.replace('/', '.');
    }

    public String getFullyName(){
        return fullyName;
    }

    public String getClassName(){
        if(className == null){
            generateClassAndPackageName();
        }
        return className;
    }

    public String getPackageName(){
        if(packageName == null){
            generateClassAndPackageName();
        }
        return packageName;
    }

    private void generateClassAndPackageName(){
        final int index = fullyName.lastIndexOf('.');
        this.className = fullyName.substring(index + 1);
        this.packageName = "";
        if(index > 0){
            packageName = fullyName.substring(0, index - 1);
        }
    }
}
