package jp.sourceforge.stigmata.digger;

/*
 * $Id: ClassFileEntry.java 307 2008-09-16 07:11:05Z tama3 $
 */

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

/**
 * This class manages class name and its location.
 *
 * @author Haruaki TAMADA
 * @version $Revision: 307 $ 
 */
public class ClassFileEntry{
    private URL location;
    private String className;

    public ClassFileEntry(String className, URL location){
        this.className = className;
        setLocation(location);
    }

    public String getClassName(){
        return className;
    }

    public void setLocation(URL location){
        this.location = location;
    }

    public URL getLocation(){
        return location;
    }

    public InputStream openStream() throws IOException{
        return getLocation().openStream();
    }
}
