/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.cluster;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.talisman.mds.cluster.ClusteringAlgorithm;
import jp.sourceforge.talisman.mds.cluster.ClusteringMethod;
import jp.sourceforge.talisman.mds.cluster.ClusteringParameter;
import jp.sourceforge.talisman.mds.cluster.ExchangeMethod;
import jp.sourceforge.talisman.mds.cluster.HierarchicalClusteringMethod;
import jp.sourceforge.talisman.mds.cluster.LanceWilliamsClusteringMethod;
import jp.sourceforge.talisman.mds.cluster.ParallelHardCMeanMethod;
import jp.sourceforge.talisman.mds.cluster.ParameterTypeMismatchException;
import jp.sourceforge.talisman.mds.cluster.SequentialHardCMeanMethod;

public class ClusteringMethodFactory {
    private static final ClusteringMethodFactory instance = new ClusteringMethodFactory();
    private Map<ClusteringAlgorithm, Class<? extends ClusteringMethod>> map = new HashMap<ClusteringAlgorithm, Class<? extends ClusteringMethod>>();

    private ClusteringMethodFactory() {
        this.map.put(ClusteringAlgorithm.EXCHANGE_METHOD, ExchangeMethod.class);
        this.map.put(ClusteringAlgorithm.PARALLEL_HCM, ParallelHardCMeanMethod.class);
        this.map.put(ClusteringAlgorithm.SEQUENTIAL_HCM, SequentialHardCMeanMethod.class);
        this.map.put(ClusteringAlgorithm.HIERARCHICAL_METHOD, HierarchicalClusteringMethod.class);
        this.map.put(ClusteringAlgorithm.LANCE_AND_WILLIAMS_METHOD, LanceWilliamsClusteringMethod.class);
    }

    public static ClusteringMethodFactory getInstance() {
        return instance;
    }

    public ClusteringMethod getAlgorithm(ClusteringAlgorithm algorithm, ClusteringParameter param) throws ParameterTypeMismatchException {
        try {
            Class<? extends ClusteringMethod> clazz = this.map.get((Object)algorithm);
            Constructor<? extends ClusteringMethod> constructor = clazz.getConstructor(ClusteringParameter.class);
            return constructor.newInstance(param);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ParameterTypeMismatchException) {
                throw (ParameterTypeMismatchException)cause;
            }
            if (cause instanceof NullPointerException) {
                throw (NullPointerException)cause;
            }
            throw new InternalError(e.getMessage());
        }
        catch (Exception e) {
            throw new InternalError(e.getMessage());
        }
    }
}

