/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.cluster;

import java.util.HashMap;
import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.cluster.Cluster;
import jp.sourceforge.talisman.mds.cluster.ClusteringParameter;
import jp.sourceforge.talisman.mds.cluster.NonHierarchicalClusteringMethod;
import jp.sourceforge.talisman.mds.cluster.NonHierarchicalClusteringParameter;
import jp.sourceforge.talisman.mds.cluster.ParameterTypeMismatchException;
import jp.sourceforge.talisman.mds.distance.ItemDistanceCalculator;

class ExchangeMethod
extends NonHierarchicalClusteringMethod {
    public ExchangeMethod(ClusteringParameter param) throws ParameterTypeMismatchException {
        super(param);
        if (!(param instanceof NonHierarchicalClusteringParameter)) {
            throw new ParameterTypeMismatchException("NonHierarchicalClusteringParameter is required");
        }
    }

    public ExchangeMethod(NonHierarchicalClusteringParameter param) {
        super(param);
    }

    protected Cluster[] doClustering(Item[] items, ClusteringParameter initParam) {
        NonHierarchicalClusteringParameter param = (NonHierarchicalClusteringParameter)initParam;
        Cluster[] clusters = this.initClusters(items, param);
        ItemDistanceCalculator id = param.getDistanceCalculator();
        HashMap<Item, Cluster> map = new HashMap<Item, Cluster>();
        for (int i = 0; i < clusters.length; ++i) {
            for (Item item : clusters[i]) {
                map.put(item, clusters[i]);
            }
        }
        boolean flag = true;
        while (flag) {
            flag = false;
            double delta = Double.MIN_VALUE;
            int target = -1;
            Item targetItem = null;
            for (int i = 0; i < items.length; ++i) {
                Cluster cluster = (Cluster)map.get(items[i]);
                double dpjA = 0.0;
                for (Item item : cluster) {
                    if (item == items[i]) continue;
                    dpjA += id.calculate(item, items[i]);
                }
                for (int j = 0; j < clusters.length; ++j) {
                    double dpjB = 0.0;
                    if (clusters[j] == cluster) continue;
                    for (Item item : clusters[j]) {
                        dpjB += id.calculate(item, items[i]);
                    }
                    double d = dpjA - dpjB;
                    if (!(delta < d)) continue;
                    delta = d;
                    target = j;
                    targetItem = items[i];
                }
            }
            if (!(delta > 0.0) || targetItem == null) continue;
            Cluster cluster = (Cluster)map.get(targetItem);
            cluster.removeItem(targetItem);
            clusters[target].addItem(targetItem);
            map.put(targetItem, clusters[target]);
            flag = true;
        }
        return clusters;
    }
}

