/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.distance;

import jp.sourceforge.talisman.mds.distance.AbstractItemDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.ItemDistanceAlgorithm;

public class DominanceMetricCalculator
extends AbstractItemDistanceCalculator {
    public ItemDistanceAlgorithm getAlgorithm() {
        return ItemDistanceAlgorithm.DOMINANCE_METRIC;
    }

    public double calculate(double[] x, double[] y) {
        this.validateArguments(x, y);
        double value = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double v;
            if (Double.isNaN(x[i]) || Double.isNaN(y[i]) || !(value < (v = Math.abs(x[i] - y[i])))) continue;
            value = v;
        }
        return value;
    }
}

