/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.distance;

import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.cluster.Cluster;
import jp.sourceforge.talisman.mds.distance.AbstractClusterDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.ClusterDistanceAlgorithm;
import jp.sourceforge.talisman.mds.distance.ItemDistanceAlgorithm;

public class GroupAverageClusterDistanceCalculator
extends AbstractClusterDistanceCalculator {
    public GroupAverageClusterDistanceCalculator() {
    }

    public GroupAverageClusterDistanceCalculator(ItemDistanceAlgorithm ida) {
        super(ida);
    }

    public ClusterDistanceAlgorithm getAlgorithm() {
        return ClusterDistanceAlgorithm.GROUP_AVERAGE_METHOD;
    }

    public double calculate(Cluster c1, Cluster c2) {
        double sum = 0.0;
        for (Item item1 : c1) {
            for (Item item2 : c2) {
                sum += this.getItemDistanceCalculator().calculate(item1, item2);
            }
        }
        return sum / (double)(c1.getSize() * c2.getSize());
    }

    public double update(Cluster ci, Cluster cj, Cluster ck, double dij, double dik, double djk) {
        int sum = ci.getSize() + cj.getSize();
        return dik * (double)ci.getSize() / (double)sum + djk * (double)cj.getSize() / (double)sum;
    }
}

