/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.distance;

import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.cluster.Cluster;
import jp.sourceforge.talisman.mds.distance.AbstractClusterDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.ClusterDistanceAlgorithm;
import jp.sourceforge.talisman.mds.distance.ItemDistanceAlgorithm;

public class NearestNeighborClusterDistanceCalculator
extends AbstractClusterDistanceCalculator {
    public NearestNeighborClusterDistanceCalculator() {
    }

    public NearestNeighborClusterDistanceCalculator(ItemDistanceAlgorithm ida) {
        super(ida);
    }

    public ClusterDistanceAlgorithm getAlgorithm() {
        return ClusterDistanceAlgorithm.NEAREST_NEIGHBOR_METHOD;
    }

    public double calculate(Cluster c1, Cluster c2) {
        double nearest = Double.MAX_VALUE;
        for (Item item1 : c1) {
            for (Item item2 : c2) {
                double value = this.getItemDistanceCalculator().calculate(item1, item2);
                if (!(nearest > value)) continue;
                nearest = value;
            }
        }
        return nearest;
    }

    public double update(Cluster ci, Cluster cj, Cluster ck, double dij, double dik, double djk) {
        return dik / 2.0 + djk / 2.0 - Math.abs(dik - djk) / 2.0;
    }
}

