/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks.is;

import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkElement;
import jp.sourceforge.stigmata.birthmarks.BirthmarkExtractVisitor;
import jp.sourceforge.stigmata.birthmarks.NullBirthmarkElement;
import jp.sourceforge.stigmata.utils.WellknownClassManager;
import org.objectweb.asm.ClassVisitor;

public class InheritanceStructureBirthmarkExtractVisitor
extends BirthmarkExtractVisitor {
    public InheritanceStructureBirthmarkExtractVisitor(ClassVisitor visitor, Birthmark birthmark, BirthmarkContext context) {
        super(visitor, birthmark, context);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        try {
            Class c = this.getEnvironment().getClasspathContext().findClass(name.replace('/', '.'));
            if (c != null && !c.isInterface()) {
                this.addISBirthmark(c);
            }
        }
        catch (ClassNotFoundException ex) {
            this.addFailur(ex);
        }
    }

    private void addISBirthmark(Class<?> c) {
        WellknownClassManager wcm = this.getEnvironment().getWellknownClassManager();
        do {
            String className = c.getName();
            BirthmarkElement element = null;
            element = wcm.isWellKnownClass(className) ? new BirthmarkElement(className) : NullBirthmarkElement.getInstance();
            this.addElement(element);
        } while (!(c = c.getSuperclass()).getName().equals("java.lang.Object"));
        this.addElement(new BirthmarkElement("java.lang.Object"));
    }
}

