/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks.kgram;

import jp.sourceforge.stigmata.BirthmarkComparator;
import jp.sourceforge.stigmata.BirthmarkElement;
import jp.sourceforge.stigmata.BirthmarkExtractor;
import jp.sourceforge.stigmata.birthmarks.AbstractBirthmarkService;
import jp.sourceforge.stigmata.birthmarks.comparators.LogicalAndBirthmarkComparator;
import jp.sourceforge.stigmata.birthmarks.kgram.KGram;
import jp.sourceforge.stigmata.birthmarks.kgram.KGramBasedBirthmarkElement;
import jp.sourceforge.stigmata.birthmarks.kgram.KGramBasedBirthmarkExtractor;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;

public class KGramBasedBirthmarkService
extends AbstractBirthmarkService
implements BirthmarkSpi {
    private BirthmarkComparator comparator = new LogicalAndBirthmarkComparator(this);
    private BirthmarkExtractor extractor = new KGramBasedBirthmarkExtractor(this);

    @Override
    public String getType() {
        return "kgram";
    }

    @Override
    public String getDefaultDescription() {
        return "k-gram based birthmark.";
    }

    @Override
    public BirthmarkExtractor getExtractor() {
        return this.extractor;
    }

    @Override
    public BirthmarkComparator getComparator() {
        return this.comparator;
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public boolean isUserDefined() {
        return false;
    }

    @Override
    public BirthmarkElement buildBirthmarkElement(String value) {
        if ((value = value.trim()).startsWith("{") && value.endsWith("}")) {
            String[] param = value.substring(1, value.length() - 1).split(", *");
            KGram<Integer> kgram = new KGram<Integer>(param.length);
            for (int i = 0; i < param.length; ++i) {
                kgram.set(i, new Integer(param[i].trim()));
            }
            return new KGramBasedBirthmarkElement(kgram);
        }
        return null;
    }
}

