/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkEnvironment;
import jp.sourceforge.stigmata.BirthmarkSet;
import jp.sourceforge.stigmata.ComparisonPair;
import jp.sourceforge.stigmata.ComparisonPairFilterSet;
import jp.sourceforge.stigmata.ComparisonResultSet;

public class FilteredComparisonResultSet
implements ComparisonResultSet {
    private ComparisonResultSet resultset;
    private List<ComparisonPairFilterSet> filters = new ArrayList<ComparisonPairFilterSet>();

    public FilteredComparisonResultSet(ComparisonResultSet resultset) {
        this.resultset = resultset;
    }

    public FilteredComparisonResultSet(ComparisonResultSet resultset, ComparisonPairFilterSet[] filters) {
        this.resultset = resultset;
        for (int i = 0; i < filters.length; ++i) {
            this.addFilterSet(filters[i]);
        }
    }

    public void addFilterSet(ComparisonPairFilterSet filter) {
        this.filters.add(filter);
    }

    public void removeFilterSet(ComparisonPairFilterSet filter) {
        this.filters.remove(filter);
    }

    @Override
    public ComparisonPair getPairAt(int index) {
        int currentIndex = 0;
        for (ComparisonPair pair : this) {
            if (currentIndex == index) {
                return pair;
            }
            ++currentIndex;
        }
        return null;
    }

    @Override
    public ComparisonPair[] getPairs() {
        ArrayList<ComparisonPair> list = new ArrayList<ComparisonPair>();
        Iterator<ComparisonPair> i = this.iterator();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list.toArray(new ComparisonPair[list.size()]);
    }

    @Override
    public int getPairCount() {
        return this.resultset.getPairCount();
    }

    @Override
    public BirthmarkContext getContext() {
        return this.resultset.getContext();
    }

    @Override
    public BirthmarkEnvironment getEnvironment() {
        return this.resultset.getEnvironment();
    }

    @Override
    public Iterator<ComparisonPair> iterator() {
        return new FilteredIterator(this.resultset.iterator());
    }

    @Override
    public synchronized BirthmarkSet[] getPairSources() {
        ArrayList<BirthmarkSet> list = new ArrayList<BirthmarkSet>();
        Iterator<BirthmarkSet> i = this.pairSources();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list.toArray(new BirthmarkSet[list.size()]);
    }

    @Override
    public Iterator<BirthmarkSet> pairSources() {
        return this.resultset.pairSources();
    }

    private class FilteredIterator
    implements Iterator<ComparisonPair> {
        private Iterator<ComparisonPair> iterator;
        private ComparisonPair next;

        public FilteredIterator(Iterator<ComparisonPair> iterator) {
            this.iterator = iterator;
            this.next = this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public ComparisonPair next() {
            ComparisonPair returnValue = this.next;
            this.next = this.findNext();
            return returnValue;
        }

        @Override
        public void remove() {
            throw new InternalError("not implemented");
        }

        private ComparisonPair findNext() {
            boolean nowFinding = true;
            while (nowFinding && this.iterator.hasNext()) {
                ComparisonPair nextPair = this.iterator.next();
                if (!this.isAllFilterPassed(nextPair)) continue;
                nowFinding = false;
                this.next = nextPair;
            }
            if (nowFinding && !this.iterator.hasNext()) {
                this.next = null;
            }
            return this.next;
        }

        private boolean isAllFilterPassed(ComparisonPair pair) {
            boolean flag = true;
            for (ComparisonPairFilterSet filter : FilteredComparisonResultSet.this.filters) {
                if (filter.isFiltered(pair)) continue;
                flag = false;
                break;
            }
            return flag;
        }
    }
}

