/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.result.history;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.sourceforge.stigmata.BirthmarkEnvironment;
import jp.sourceforge.stigmata.ExtractionResultSet;
import jp.sourceforge.stigmata.result.XmlFileExtractionResultSet;
import jp.sourceforge.stigmata.result.history.ExtractedBirthmarkHistory;
import jp.sourceforge.stigmata.utils.Utility;

public class XmlFileExtractedBirthmarkHistory
implements ExtractedBirthmarkHistory {
    private File parent;
    private Map<String, File> files = new LinkedHashMap<String, File>();

    public XmlFileExtractedBirthmarkHistory() {
        this(new File(BirthmarkEnvironment.getStigmataHome(), "extracted_birthmarks"));
    }

    public XmlFileExtractedBirthmarkHistory(String path) {
        this(new File(path));
    }

    public XmlFileExtractedBirthmarkHistory(File parent) {
        this.parent = parent;
        this.refresh();
    }

    @Override
    public void refresh() {
        this.files.clear();
        if (this.parent.exists()) {
            for (File file : this.parent.listFiles()) {
                if (!this.isTarget(file)) continue;
                this.files.put(file.getName(), file);
            }
        }
    }

    @Override
    public void deleteAllResultSets() {
        for (File file : this.parent.listFiles()) {
            if (!this.isTarget(file)) continue;
            Utility.deleteDirectory(file);
        }
    }

    @Override
    public void deleteResultSet(String id) {
        File file = this.files.get(id);
        if (file != null) {
            if (file.isDirectory()) {
                Utility.deleteDirectory(file);
            } else {
                file.delete();
            }
        }
    }

    @Override
    public ExtractionResultSet getResultSet(String id) {
        File file = this.files.get(id);
        if (file != null) {
            return new XmlFileExtractionResultSet(file);
        }
        return null;
    }

    @Override
    public synchronized String[] getResultSetIds() {
        return this.files.keySet().toArray(new String[this.files.size()]);
    }

    @Override
    public Iterator<String> iterator() {
        return this.files.keySet().iterator();
    }

    private boolean isTarget(File file) {
        return file.isDirectory() && file.getName().matches("\\d\\d\\d\\d\\d\\d\\d\\d-\\d\\d\\d\\d\\d\\d.\\d\\d\\d");
    }
}

