/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;
import jp.sourceforge.stigmata.ui.swing.BirthmarkSelection;
import jp.sourceforge.stigmata.ui.swing.BirthmarkServiceListener;
import jp.sourceforge.stigmata.ui.swing.DataChangeListener;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;
import jp.sourceforge.talisman.i18n.Messages;

public abstract class BirthmarkSelectablePane
extends JPanel
implements BirthmarkServiceListener {
    private static final long serialVersionUID = 7057130952947891635L;
    private StigmataFrame stigmata;
    private Set<String> selectedServices = new HashSet<String>();
    private Map<String, BirthmarkSelection> services;
    private List<DataChangeListener> listeners = new ArrayList<DataChangeListener>();
    private boolean expertmode;

    public BirthmarkSelectablePane(StigmataFrame stigmata) {
        this.stigmata = stigmata;
        this.initServices();
        stigmata.addBirthmarkServiceListener(this);
    }

    protected abstract void updateLayouts();

    public Messages getMessages() {
        return this.stigmata.getMessages();
    }

    public void setExpertMode(boolean expertmode) {
        this.expertmode = expertmode;
        this.updateLayouts();
    }

    public boolean isExpertMode() {
        return this.expertmode;
    }

    public String[] getSelectedServiceTypes() {
        return this.selectedServices.toArray(new String[this.selectedServices.size()]);
    }

    public BirthmarkSpi getService(String type) {
        BirthmarkSelection elem = this.services.get(type);
        if (elem != null) {
            return elem.getService();
        }
        return null;
    }

    public String[] getServiceTypes() {
        String[] serviceArray = new String[this.services.size()];
        int index = 0;
        for (String key : this.services.keySet()) {
            BirthmarkSpi service = this.services.get(key).getService();
            serviceArray[index] = service.getType();
            ++index;
        }
        return serviceArray;
    }

    public boolean hasService(String type) {
        return this.services.get(type) != null;
    }

    public void select(String type, boolean flag) {
        if (flag) {
            this.selectedServices.add(type);
        } else {
            this.selectedServices.remove(type);
        }
        this.fireEvent();
    }

    public void select(BirthmarkSpi service, boolean flag) {
        this.select(service.getType(), flag);
    }

    public void reset() {
        this.selectedServices.clear();
        this.initServices();
        this.expertmode = false;
        this.updateLayouts();
        this.fireEvent();
    }

    public void addDataChangeListener(DataChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void serviceAdded(BirthmarkSpi service) {
        if (this.services.get(service.getType()) == null) {
            BirthmarkSelection elem = new BirthmarkSelection(service);
            this.selectedServices.add(service.getType());
            this.services.put(service.getType(), elem);
        }
        this.updateLayouts();
        this.fireEvent();
    }

    @Override
    public void serviceRemoved(BirthmarkSpi service) {
        BirthmarkSelection elem = this.services.get(service);
        if (elem != null) {
            this.selectedServices.remove(service);
            this.services.remove(service);
        }
        this.fireEvent();
    }

    public Iterator<String> serviceNames() {
        return this.services.keySet().iterator();
    }

    protected BirthmarkSelection getSelection(String type) {
        return this.services.get(type);
    }

    protected Iterator<BirthmarkSelection> birthmarkSelections() {
        return this.services.values().iterator();
    }

    protected void fireEvent() {
        for (DataChangeListener listener : this.listeners) {
            listener.valueChanged(this);
        }
    }

    private void initServices() {
        BirthmarkSpi[] serviceArray = this.stigmata.getEnvironment().getServices();
        this.services = new LinkedHashMap<String, BirthmarkSelection>();
        for (BirthmarkSpi service : serviceArray) {
            BirthmarkSelection elem = new BirthmarkSelection(service);
            this.services.put(service.getType(), elem);
        }
    }
}

