/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkEnvironment;
import jp.sourceforge.stigmata.BirthmarkStoreTarget;
import jp.sourceforge.stigmata.ComparisonMethod;
import jp.sourceforge.stigmata.ExtractionUnit;
import jp.sourceforge.stigmata.Stigmata;
import jp.sourceforge.stigmata.digger.ClasspathContext;
import jp.sourceforge.stigmata.filter.ComparisonPairFilterManager;
import jp.sourceforge.stigmata.ui.swing.BirthmarkDefinitionPane;
import jp.sourceforge.stigmata.ui.swing.BirthmarkSelectablePane;
import jp.sourceforge.stigmata.ui.swing.BirthmarkSelectionCheckSetPane;
import jp.sourceforge.stigmata.ui.swing.BirthmarkServiceListener;
import jp.sourceforge.stigmata.ui.swing.ClasspathSettingsPane;
import jp.sourceforge.stigmata.ui.swing.DataChangeListener;
import jp.sourceforge.stigmata.ui.swing.ExtractedHistoryPane;
import jp.sourceforge.stigmata.ui.swing.FilterManagementPane;
import jp.sourceforge.stigmata.ui.swing.FilterSelectionPane;
import jp.sourceforge.stigmata.ui.swing.GUIUtility;
import jp.sourceforge.stigmata.ui.swing.PopupButton;
import jp.sourceforge.stigmata.ui.swing.PropertyEditPane;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;
import jp.sourceforge.stigmata.ui.swing.TargetSelectionPane;
import jp.sourceforge.stigmata.ui.swing.WellknownClassesSettingsPane;
import jp.sourceforge.stigmata.utils.ConfigFileExporter;
import jp.sourceforge.stigmata.utils.WellknownClassManager;

public class ControlPane
extends JPanel {
    private static final long serialVersionUID = 983547612346543645L;
    private StigmataFrame stigmata;
    private BirthmarkSelectablePane birthmarks;
    private TargetSelectionPane targetX;
    private TargetSelectionPane targetY;
    private ClasspathSettingsPane classpath;
    private WellknownClassesSettingsPane wellknownClassses;
    private BirthmarkDefinitionPane definition;
    private PropertyEditPane properties;
    private FilterManagementPane filters;
    private ExtractedHistoryPane history;
    private JTabbedPane controlTab;
    private JButton compareButton;
    private JButton extractButton;
    private JButton resetButton;
    private PopupButton comparePopup;
    private JComboBox unitBox;
    private Map<String, String> unitLabels = new HashMap<String, String>();
    private boolean expertmode = false;

    public ControlPane(StigmataFrame stigmata) {
        this.stigmata = stigmata;
    }

    void inititalize() {
        this.definition = new BirthmarkDefinitionPane(this.stigmata);
        this.birthmarks = new BirthmarkSelectionCheckSetPane(this.stigmata);
        this.properties = new PropertyEditPane(this.stigmata);
        JComponent control = this.createControlPane();
        this.wellknownClassses = new WellknownClassesSettingsPane(this.stigmata);
        this.classpath = new ClasspathSettingsPane(this.stigmata);
        this.filters = new FilterManagementPane(this.stigmata);
        this.history = new ExtractedHistoryPane(this.stigmata);
        this.initComponents();
        GUIUtility.addNewTab(this.stigmata.getMessages(), "targets", this.controlTab, control);
        GUIUtility.addNewTab(this.stigmata.getMessages(), "wellknown", this.controlTab, this.wellknownClassses);
        GUIUtility.addNewTab(this.stigmata.getMessages(), "classpath", this.controlTab, this.classpath);
        GUIUtility.addNewTab(this.stigmata.getMessages(), "property", this.controlTab, this.properties);
        this.controlTab.setSelectedIndex(0);
        this.reset();
    }

    public void addBirthmarkServiceListener(BirthmarkServiceListener listener) {
        this.definition.addBirthmarkServiceListener(listener);
    }

    public void removeBirthmarkServiceListener(BirthmarkServiceListener listener) {
        this.definition.removeBirthmarkServiceListener(listener);
    }

    public void reset() {
        int filterTabIndex;
        this.expertmode = false;
        this.definition.reset();
        this.birthmarks.reset();
        this.stigmata.setExpertMode(false);
        this.targetX.removeAllElements();
        this.targetY.removeAllElements();
        this.classpath.reset();
        this.wellknownClassses.reset();
        this.filters.reset();
        this.updateEnable();
        int definitionTabIndex = this.controlTab.indexOfTab(this.stigmata.getMessages().get("definition.tab.label"));
        if (definitionTabIndex >= 0) {
            this.controlTab.removeTabAt(definitionTabIndex);
        }
        if ((filterTabIndex = this.controlTab.indexOfTab(this.stigmata.getMessages().get("filter.tab.label"))) >= 0) {
            this.controlTab.removeTabAt(filterTabIndex);
        }
    }

    public void saveSettings(File file) {
        BirthmarkEnvironment environment = this.generateEnvironment();
        ConfigFileExporter bce = new ConfigFileExporter(environment);
        try {
            PrintWriter out = new PrintWriter(new FileWriter(file));
            bce.export(out);
            out.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.stigmata, this.stigmata.getMessages().get("error.io", e.getMessage()), this.stigmata.getMessages().get("error.dialog.title"), 0);
        }
    }

    public void exportSettings() {
        File file = this.stigmata.getSaveFile(this.stigmata.getMessages().getArray("export.extensions"), this.stigmata.getMessages().get("export.description"));
        if (file != null) {
            if (!file.getName().endsWith(".xml")) {
                file = new File(file.getParent(), file.getName() + ".xml");
            }
            this.saveSettings(file);
        }
    }

    public void setExpertMode(boolean expertmode) {
        this.expertmode = expertmode;
        this.birthmarks.setExpertMode(expertmode);
        this.stigmata.setExpertMode(expertmode);
        if (expertmode) {
            int index = this.controlTab.getSelectedIndex();
            GUIUtility.addNewTab(this.stigmata.getMessages(), "definition", this.controlTab, this.definition);
            GUIUtility.addNewTab(this.stigmata.getMessages(), "filter", this.controlTab, this.filters);
            GUIUtility.addNewTab(this.stigmata.getMessages(), "history", this.controlTab, this.history);
            this.controlTab.setSelectedIndex(index);
        } else {
            this.removeTabByName(this.stigmata.getMessages().get("definition.tab.label"));
            this.removeTabByName(this.stigmata.getMessages().get("filter.tab.label"));
            this.removeTabByName(this.stigmata.getMessages().get("history.tab.label"));
        }
        this.updateEnable();
    }

    public boolean isExpertMode() {
        return this.expertmode;
    }

    private void removeTabByName(String tabname) {
        int index = this.controlTab.indexOfTab(tabname);
        if (index >= 0) {
            this.controlTab.removeTabAt(index);
        }
    }

    private JComponent createControlPane() {
        Box mainPane = new Box(0);
        JPanel center = new JPanel(new BorderLayout());
        this.targetX = new TargetSelectionPane(this.stigmata);
        this.targetY = new TargetSelectionPane(this.stigmata);
        this.birthmarks.setBorder(new TitledBorder(this.stigmata.getMessages().get("birthmarkspane.border")));
        this.targetX.addTargetExtensions(this.stigmata.getMessages().getArray("targets.extensions"));
        this.targetX.setDescription(this.stigmata.getMessages().get("targets.description"));
        this.targetX.setBorder(new TitledBorder(this.stigmata.getMessages().get("targetx.border")));
        this.targetY.addTargetExtensions(this.stigmata.getMessages().getArray("targets.extensions"));
        this.targetY.setDescription(this.stigmata.getMessages().get("targets.description"));
        this.targetY.setBorder(new TitledBorder(this.stigmata.getMessages().get("targety.border")));
        center.add((Component)mainPane, "Center");
        center.add((Component)this.birthmarks, "South");
        mainPane.add(Box.createHorizontalGlue());
        mainPane.add(this.targetX);
        mainPane.add(Box.createHorizontalGlue());
        mainPane.add(this.targetY);
        mainPane.add(Box.createHorizontalGlue());
        DataChangeListener dcl = new DataChangeListener(){

            @Override
            public void valueChanged(Object source) {
                ControlPane.this.updateEnable();
            }
        };
        this.targetX.addDataChangeListener(dcl);
        this.targetY.addDataChangeListener(dcl);
        this.birthmarks.addDataChangeListener(dcl);
        return center;
    }

    private void updateEnable() {
        String[] valueX = this.targetX.getValues();
        String[] valueY = this.targetY.getValues();
        String[] targets = this.birthmarks.getSelectedServiceTypes();
        this.extractButton.setEnabled((valueX != null && valueX.length > 0 || valueY != null && valueY.length > 0) && targets != null && targets.length > 0);
        this.comparePopup.setEnabled(valueX != null && valueX.length > 0 && valueY != null && valueY.length > 0 && targets != null && targets.length > 0);
    }

    private void extractButtonActionPerformed(ActionEvent e) {
        BirthmarkContext context = this.generateContext();
        context.setComparisonMethod(ComparisonMethod.ROUND_ROBIN_XY);
        String[] fileX = this.targetX.getValues();
        String[] fileY = this.targetY.getValues();
        this.stigmata.extract(fileX, fileY, context);
    }

    private void compareRoundRobinWithFiltering() {
        BirthmarkContext context = this.generateContext();
        context.setComparisonMethod(ComparisonMethod.ROUND_ROBIN_XY);
        FilterSelectionPane pane = new FilterSelectionPane(this.stigmata, context.getEnvironment().getFilterManager());
        int returnValue = JOptionPane.showConfirmDialog(this.stigmata, pane, this.stigmata.getMessages().get("filterselection.dialog.title"), 2, 3);
        if (returnValue == 0) {
            String[] filterSetList = pane.getSelectedFilters();
            context.setFilterTypes(filterSetList);
            String[] fileX = this.targetX.getValues();
            String[] fileY = this.targetY.getValues();
            this.stigmata.compareRoundRobinFilter(fileX, fileY, context);
        }
    }

    private void compareRoundRobin() {
        BirthmarkContext context = this.generateContext();
        context.setComparisonMethod(ComparisonMethod.ROUND_ROBIN_XY);
        String[] fileX = this.targetX.getValues();
        String[] fileY = this.targetY.getValues();
        this.stigmata.compareRoundRobin(fileX, fileY, context);
    }

    private void compareSpecifiedPair() {
        BirthmarkContext context = this.generateContext();
        context.setComparisonMethod(ComparisonMethod.SPECIFIED_PAIR);
        String[] fileX = this.targetX.getValues();
        String[] fileY = this.targetY.getValues();
        this.stigmata.compareSpecifiedPair(fileX, fileY, context);
    }

    private void compareGuessedPair() {
        BirthmarkContext context = this.generateContext();
        context.setComparisonMethod(ComparisonMethod.GUESSED_PAIR);
        String[] fileX = this.targetX.getValues();
        String[] fileY = this.targetY.getValues();
        this.stigmata.compareGuessedPair(fileX, fileY, context);
    }

    private BirthmarkContext generateContext() {
        BirthmarkContext context = new BirthmarkContext(this.generateEnvironment());
        context.setBirthmarkTypes(this.birthmarks.getSelectedServiceTypes());
        context.setExtractionUnit(this.parseExtractionUnit());
        BirthmarkStoreTarget bst = BirthmarkStoreTarget.MEMORY;
        if (context.getEnvironment().getProperty("birthmark.store.target") != null) {
            bst = BirthmarkStoreTarget.valueOf(context.getEnvironment().getProperty("birthmark.store.target"));
        }
        if (bst == null) {
            bst = BirthmarkStoreTarget.MEMORY;
        }
        context.setStoreTarget(bst);
        return context;
    }

    private BirthmarkEnvironment generateEnvironment() {
        BirthmarkEnvironment environment = Stigmata.getInstance().createEnvironment();
        ClasspathContext bytecode = environment.getClasspathContext();
        WellknownClassManager manager = environment.getWellknownClassManager();
        ComparisonPairFilterManager filterManager = environment.getFilterManager();
        this.classpath.updateClasspathContext(bytecode);
        this.wellknownClassses.setWellknownClasses(manager);
        this.filters.updateFilterManager(filterManager);
        this.definition.updateEnvironment(environment);
        this.properties.updateEnvironment(environment);
        return environment;
    }

    private ExtractionUnit parseExtractionUnit() {
        String label = (String)this.unitBox.getSelectedItem();
        String key = this.unitLabels.get(label);
        ExtractionUnit unit = ExtractionUnit.CLASS;
        unit = key.equals("unit.archive") ? ExtractionUnit.ARCHIVE : (key.equals("unit.package") ? ExtractionUnit.PACKAGE : ExtractionUnit.CLASS);
        return unit;
    }

    private void initComponents() {
        this.controlTab = new JTabbedPane();
        this.resetButton = GUIUtility.createButton(this.stigmata.getMessages(), "reset");
        this.extractButton = GUIUtility.createButton(this.stigmata.getMessages(), "extract");
        this.compareButton = GUIUtility.createButton(this.stigmata.getMessages(), "roundrobin");
        this.comparePopup = new PopupButton(this.compareButton);
        this.unitBox = new JComboBox();
        Box south = Box.createHorizontalBox();
        south.add(Box.createHorizontalGlue());
        south.add(this.resetButton);
        south.add(Box.createHorizontalGlue());
        south.add(this.extractButton);
        south.add(Box.createHorizontalGlue());
        south.add(this.comparePopup);
        south.add(Box.createHorizontalGlue());
        south.add(this.unitBox);
        south.add(Box.createHorizontalGlue());
        this.setLayout(new BorderLayout());
        this.add((Component)south, "South");
        this.add((Component)this.controlTab, "Center");
        this.extractButton.setEnabled(false);
        this.comparePopup.setEnabled(false);
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPane.this.reset();
            }
        });
        this.extractButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPane.this.extractButtonActionPerformed(e);
            }
        });
        ActionListener compareListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command.equals("roundrobin")) {
                    ControlPane.this.compareRoundRobin();
                } else if (command.equals("guessedpair")) {
                    ControlPane.this.compareGuessedPair();
                } else if (command.equals("specifiedpair")) {
                    ControlPane.this.compareSpecifiedPair();
                } else if (command.equals("roundrobin.filtering")) {
                    ControlPane.this.compareRoundRobinWithFiltering();
                }
            }
        };
        this.compareButton.addActionListener(compareListener);
        String[] comparisonMethods = this.stigmata.getMessages().getArray("comparison.methods");
        for (int i = 1; i < comparisonMethods.length; ++i) {
            JMenuItem item = GUIUtility.createJMenuItem(this.stigmata.getMessages(), comparisonMethods[i]);
            this.comparePopup.addMenuItem(item);
            item.addActionListener(compareListener);
        }
        String[] extractionUnits = this.stigmata.getMessages().getArray("extraction.units");
        for (int i = 0; i < extractionUnits.length; ++i) {
            String label = this.stigmata.getMessages().get(extractionUnits[i]);
            this.unitLabels.put(label, extractionUnits[i]);
            this.unitBox.addItem(label);
        }
    }
}

