/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import jp.sourceforge.stigmata.BirthmarkSet;
import jp.sourceforge.stigmata.ComparisonPair;
import jp.sourceforge.stigmata.ComparisonPairElement;
import jp.sourceforge.stigmata.printer.PrinterManager;
import jp.sourceforge.stigmata.spi.ResultPrinterSpi;
import jp.sourceforge.stigmata.ui.swing.BirthmarkTreeNode;
import jp.sourceforge.stigmata.ui.swing.ClippedLRListCellRenderer;
import jp.sourceforge.stigmata.ui.swing.GUIUtility;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;
import jp.sourceforge.stigmata.ui.swing.actions.SaveAction;
import jp.sourceforge.stigmata.utils.AsciiDataWritable;

public class PairComparisonPane
extends JPanel {
    private static final long serialVersionUID = 2342856785474356234L;
    private StigmataFrame frame;
    private ComparisonPair pair;

    public PairComparisonPane(StigmataFrame frame, ComparisonPair pair) {
        this.frame = frame;
        this.pair = pair;
        this.initialize(frame);
    }

    private void initialize(StigmataFrame frame) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getSouthPanel(frame), "South");
        this.add((Component)this.getMainPane(frame), "Center");
    }

    private JPanel getSouthPanel(StigmataFrame stigmata) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel similarityPanel = new JPanel();
        similarityPanel.setLayout(new GridLayout(1, 3));
        JLabel label = new JLabel(Double.toString(this.pair.calculateSimilarity()));
        label.setBorder(BorderFactory.createTitledBorder(stigmata.getMessages().get("result.border")));
        JComboBox<ClippedLRListCellRenderer.LRItem> combo = new JComboBox<ClippedLRListCellRenderer.LRItem>();
        for (ComparisonPairElement elem : this.pair) {
            combo.addItem(new ClippedLRListCellRenderer.LRItem(elem.getType(), elem.getSimilarity()));
        }
        combo.setRenderer(new ClippedLRListCellRenderer(new Dimension(100, combo.getPreferredSize().height), 50));
        combo.setBorder(BorderFactory.createTitledBorder(stigmata.getMessages().get("eachbirthmarksimilarity.border")));
        similarityPanel.add(label);
        similarityPanel.add(combo);
        similarityPanel.setBorder(new TitledBorder(stigmata.getMessages().get("similarity.border")));
        panel.add(similarityPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton saveButton = GUIUtility.createButton(this.frame.getMessages(), "savecomparison", new SaveAction(this.frame, new AsciiDataWritable(){

            @Override
            public void writeAsciiData(PrintWriter out, String format) throws IOException {
                ResultPrinterSpi service = PrinterManager.getInstance().getService(format);
                if (service == null) {
                    service = PrinterManager.getDefaultFormatService();
                }
                service.getComparisonPairPrinter().printResult(out, PairComparisonPane.this.pair);
            }
        }));
        buttonPanel.add(saveButton);
        panel.add(buttonPanel);
        return panel;
    }

    private JSplitPane getMainPane(StigmataFrame frame) {
        JSplitPane spliter = new JSplitPane();
        spliter.setLeftComponent(this.getSpliterPanel(frame, this.pair.getTarget1()));
        spliter.setRightComponent(this.getSpliterPanel(frame, this.pair.getTarget2()));
        spliter.setDividerLocation((spliter.getWidth() - spliter.getDividerSize()) / 2);
        spliter.setContinuousLayout(true);
        return spliter;
    }

    private JPanel getSpliterPanel(StigmataFrame stigmata, BirthmarkSet birthmark) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JTree tree = new JTree(new BirthmarkTreeNode(birthmark));
        panel.add((Component)new JScrollPane(tree), "Center");
        JPanel south = new JPanel(new BorderLayout());
        panel.add((Component)south, "South");
        JLabel elementCount = new JLabel(Integer.toString(birthmark.getSumOfElementCount()));
        elementCount.setBorder(new TitledBorder(stigmata.getMessages().get("elementcount.border")));
        south.add((Component)elementCount, "Center");
        return panel;
    }
}

