/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing.actions;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import jp.sourceforge.stigmata.ui.swing.GUIUtility;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;

public class ChangeColorAction
extends AbstractAction {
    private static final long serialVersionUID = -7617597154707466764L;
    private StigmataFrame frame;
    private Color currentColor = Color.RED;
    private JColorChooser chooser;
    private boolean colorSelected = false;
    private ActionListener listener;

    public ChangeColorAction(String label, StigmataFrame frame, Color initialColor, ActionListener listener) {
        super(frame.getMessages().get(label + ".label"), GUIUtility.getIcon(frame.getMessages(), label + ".icon"));
        this.frame = frame;
        this.listener = listener;
        this.currentColor = initialColor;
        this.chooser = new JColorChooser();
        this.chooser.setColor(initialColor);
    }

    public ChangeColorAction(StigmataFrame frame, Color color, ActionListener listener) {
        this("changecolor", frame, color, listener);
    }

    public ChangeColorAction(StigmataFrame frame, ActionListener listener) {
        this(frame, Color.RED, listener);
    }

    public boolean isColorSelected() {
        return this.colorSelected;
    }

    public Color getColor() {
        return this.currentColor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.chooser.setColor(this.currentColor);
        JDialog dialog = JColorChooser.createDialog(this.frame, this.frame.getMessages().get("changecolor.title"), true, this.chooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeColorAction.this.currentColor = ChangeColorAction.this.chooser.getColor();
                ChangeColorAction.this.colorSelected = true;
                ChangeColorAction.this.listener.actionPerformed(new ActionEvent(ChangeColorAction.this, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeColorAction.this.colorSelected = false;
            }
        });
        dialog.setVisible(true);
    }
}

