/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing.actions;

import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;
import jp.sourceforge.stigmata.ui.swing.UnsupportedFormatException;
import jp.sourceforge.stigmata.utils.AsciiDataWritable;
import jp.sourceforge.stigmata.utils.BinaryDataWritable;

public class SaveAction
extends AbstractAction {
    private static final long serialVersionUID = 1427912047636729211L;
    private AsciiDataWritable asciiWritable;
    private BinaryDataWritable binaryWritable;
    private StigmataFrame stigmata;
    private String[] extensions;
    private String description;

    public SaveAction(StigmataFrame stigmata, AsciiDataWritable writable) {
        this.stigmata = stigmata;
        this.asciiWritable = writable;
    }

    public SaveAction(StigmataFrame stigmata, BinaryDataWritable writable) {
        this.stigmata = stigmata;
        this.binaryWritable = writable;
    }

    public void setExtensions(String[] extensions) {
        this.extensions = extensions;
    }

    public void setDescrpition(String description) {
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        if (this.extensions == null || this.description == null) {
            this.extensions = this.stigmata.getMessages().getArray("store.extensions");
            this.description = this.stigmata.getMessages().get("store.description");
        }
        if ((file = this.stigmata.getSaveFile(this.extensions, this.description)) != null) {
            String name = file.getName();
            String format = name.substring(name.lastIndexOf(46) + 1, name.length());
            OutputStream out = null;
            PrintWriter writer = null;
            try {
                if (this.asciiWritable != null) {
                    writer = new PrintWriter(new FileWriter(file));
                    this.asciiWritable.writeAsciiData(writer, format);
                } else {
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    this.binaryWritable.writeBinaryData(out, format);
                }
            }
            catch (IOException ee) {
                JOptionPane.showMessageDialog(this.stigmata, ee.getMessage(), this.stigmata.getMessages().get("error.dialog.title"), 0);
            }
            catch (UnsupportedFormatException ee) {
                JOptionPane.showMessageDialog(this.stigmata, ee.getMessage(), this.stigmata.getMessages().get("error.dialog.title"), 0);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ee) {
                        throw new InternalError(ee.getMessage());
                    }
                }
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }
}

