/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.csvio.builder;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.talisman.csvio.CsvIOSetting;
import jp.sourceforge.talisman.csvio.EscapeMode;
import jp.sourceforge.talisman.csvio.builder.AbstractCsvLineBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QuoteAsNeededCsvLineBuilder
extends AbstractCsvLineBuilder {
    public QuoteAsNeededCsvLineBuilder() {
    }

    public QuoteAsNeededCsvLineBuilder(CsvIOSetting setting) {
        super(setting);
    }

    @Override
    protected List<String> splitToTokens(String line) {
        CsvIOSetting setting = this.getSetting();
        List<String> strings = setting.getEscapeMode() == EscapeMode.ESCAPE_CHARACTER ? this.splitToTokensEscapeChar(line, setting) : this.splitToTokensDoubleEscapeChar(line, setting);
        return strings;
    }

    private List<String> splitToTokensDoubleEscapeChar(String line, CsvIOSetting setting) {
        ArrayList<String> strings = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int length = line.length();
        int current = 0;
        boolean quote = false;
        char QB = setting.getQuoteBegin();
        char QE = setting.getQuoteEnd();
        while (current < length) {
            char c = line.charAt(current);
            ++current;
            if (c == QB) {
                if (current < length && line.charAt(current) == QB) {
                    sb.append(c);
                    ++current;
                    continue;
                }
                if (quote && c == QE) {
                    quote = false;
                    continue;
                }
                quote = true;
                continue;
            }
            if (c == QE) {
                if (current < length && line.charAt(current) == QE) {
                    sb.append(c);
                    ++current;
                    continue;
                }
                quote = false;
                continue;
            }
            if (c == setting.getSeparator()) {
                if (quote) {
                    sb.append(c);
                    continue;
                }
                strings.add(new String(sb));
                sb.delete(0, sb.length());
                quote = false;
                continue;
            }
            sb.append(c);
        }
        strings.add(new String(sb));
        sb.delete(0, sb.length());
        return strings;
    }

    private List<String> splitToTokensEscapeChar(String line, CsvIOSetting setting) {
        ArrayList<String> strings = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int length = line.length();
        boolean quotation = false;
        boolean escape = false;
        for (int i = 0; i < length; ++i) {
            char c = line.charAt(i);
            if (escape) {
                sb.append(c);
                escape = false;
                continue;
            }
            if (quotation) {
                if (c == setting.getEscapeCharacter()) {
                    escape = true;
                    continue;
                }
                if (c == setting.getQuoteEnd()) {
                    quotation = false;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == setting.getQuoteBegin()) {
                quotation = true;
                continue;
            }
            if (c == setting.getEscapeCharacter()) {
                escape = true;
                continue;
            }
            if (c == setting.getSeparator()) {
                strings.add(new String(sb));
                sb.delete(0, sb.length());
                continue;
            }
            sb.append(c);
        }
        strings.add(new String(sb));
        sb.delete(0, sb.length());
        return strings;
    }
}

