package jp.sourceforge.stigmata.birthmarks.comparators;

/*
 * $Id: LogicalAndBirthmarkComparatorService.java 294 2008-07-11 08:51:37Z tama3 $
 */

import jp.sourceforge.stigmata.BirthmarkComparator;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;

/**
 * SPI of {@link BirthmarkComparator <code>BirthmarkComparator</code>}.
 * Comparing birthmarks by logical AND algorithm.
 *
 * @author Haruaki TAMADA
 * @version $Revision: 294 $ 
 */
public class LogicalAndBirthmarkComparatorService extends AbstractBirthmarkComparatorService{
    /**
     * returns a type of the birthmark this service provides.
     */
    public String getType(){
        return "and";
    }

    public String getComparatorClassName(){
        return LogicalAndBirthmarkComparator.class.getName();
    }

    /**
     * returns a extractor for the birthmark of this service.
     */
    public BirthmarkComparator getComparator(BirthmarkSpi service){
        return new LogicalAndBirthmarkComparator(service);
    }
}

