package jp.sourceforge.stigmata.utils;

/*
 * $Id: ArrayIterator.java 294 2008-07-11 08:51:37Z tama3 $
 */

import java.util.Iterator;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revission$ 
 */
public class ArrayIterator<T> implements Iterator<T>{
    private T[] values;
    private int length;
    private int currentIndex = 0;

    public ArrayIterator(T[] values){
        this.values = values;
        if(values != null){
            length = values.length;
        }
        else{
            length = 0;
        }
    }

    public boolean hasNext(){
        return currentIndex < length;
    }

    public T next(){
        T value = values[currentIndex];
        currentIndex++;
        return value;
    }

    public void remove(){
    }
}
