# gnu compile script for Coterminal apps:

#============================================================
#
# uses the Xlinker command to set runtime relative library 
# paths within the executables with the following 2 lines:
#
# -Xlinker -rpath='$ORIGIN/libs/gnu' \
# -Xlinker -rpath='$ORIGIN/../../libs/gnu' \
#
# The first line sets path relative to the base directory
# in case some exe is moved there so it will still run;
# while the 2nd line set path relative to the directory
# ./bin/gnu/ which is where the precompiled exes are put.
#
#====================================================================




# prepend path to gnatmake:
export PATH=/usr/gnat/bin:$PATH


gnatmake $1 \
-O3 -gnat12 \
-I$PWD/adainclude \
--subdirs=./obj \
-largs \
-Xlinker -rpath='$ORIGIN/libs/gnu' \
-Xlinker -rpath='$ORIGIN/../../libs/gnu' \
-L$PWD/libs/gnu -lgnatcoll -lgnarl -lgnat -lgcc_s -lgpr

mv ./obj/$1 ./bin/gnu/
rm ./obj/*



# -- Copyright (C) 2017  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.



