/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 */
package dwarf.jsf.context;

import dwarf.MockConstants;
import dwarf.jsf.support.ExternalRMap;
import dwarf.jsf.support.ExternalRPMap;
import dwarf.jsf.support.SessionMap;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *  OReLXgEC^[tF[X̎
 */
public class ExternalContextGx extends ExternalContext {

  static final Log log = LogFactory.getLog(ExternalContextGx.class);
  /** RXgN^ */
  public ExternalContextGx(Object sc, Object request, Object response) {
    servletContext = sc;
    this.request = request;
    this.response = response;
  }

  /** RXgN^ */
  public ExternalContextGx() {
  }
  protected Map applicationMap = null;

  public Map getApplicationMap() {
    if (applicationMap != null) return applicationMap;
    applicationMap = new AppMap((ServletContext) servletContext);
    return applicationMap;
  }


  private Object servletContext = null;
  private Object request = null;
  private Object response = null;;

  private Map requestMap = null;
  private Map requestParameterMap = null;

  StringWriter stringWriter = null;
  PrintWriter printWriter = null;


  public void release() {
    servletContext = null;
    request = null;
    response = null;;
    requestMap = null;
    requestParameterMap = null;
    stringWriter = null;
    printWriter = null;
  }



  public void setData() throws IOException {

    RequestParameterMap requestParameterMap = new RequestParameterMap();
    setData(requestParameterMap);
    this.requestParameterMap = requestParameterMap;   // 2006.12.04

    String[] roll = new String[0];
    setRolls(roll);
  }

  public void setData(Map af) throws IOException {

    HttpServletRequest req = (HttpServletRequest) request;

    _getParameters(af, req);

    af.put(MockConstants.REQUEST_SCHEME, req.getScheme());
    af.put(MockConstants.REQUEST_HOST, "" + req.getHeader("Host")); // null΍
    af.put(MockConstants.REQUEST_URI, req.getRequestURI());
  }

  /**
   *
   */
  private static void _getParameters(Map af, HttpServletRequest req) throws IOException {
    Enumeration e = req.getParameterNames();
    while (e.hasMoreElements()) {
      String key = (String) e.nextElement();
      String[] values = req.getParameterValues(key);
      String userIn = new String(values[0].getBytes("8859_1"), "MS932");
      af.put( key , removeControlCode(userIn));
    }
  }
  //-----------------------------------------------------------

  public Map getRequestParameterMap() {
    if (null == requestParameterMap) {
      requestParameterMap = new ExternalRPMap((ServletRequest)request);
    }
    return requestParameterMap;
  }
  
  public Map getRequestMap() {
    if (null == requestMap) {
      requestMap = new ExternalRMap((ServletRequest)request);
    }
    return requestMap;
  }

  public Map getRequestParameterValuesMap() {
    throw new UnsupportedOperationException();
  }

  //-----------------------------------------------------------
  private static String removeControlCode(String in) {

    StringBuffer sb = new StringBuffer();
    int n = in.length();
    for (int i = 0; i < n; i++) {
      char c = in.charAt(i);
      if (c == 0x7f) {
      } else if ('\0' <= c && c < ' ') {
      } else {
        sb.append(c);
      }
    }
    return sb.toString();
  }
/*
*/
  public String getContentType() {
    HttpServletRequest req = (HttpServletRequest) request;
    return req.getContentType();
  }


  public String getOutputString() {
    return stringWriter.toString();
  }

  public Object getContext() {
    return servletContext;
  }

  public void setContext(Object newValue) {
    servletContext = newValue;
  }

  public Object getRequest() {
    return request;
  }
  public Object getResponse() {
    return response;
  }

  public Object getSession(boolean flag) {

    if (request instanceof HttpServletRequest) {
      HttpServletRequest req = (HttpServletRequest) request;
      return req.getSession(flag);
    }
    return null;
  }

  public void setRequestMap(Map newValue) {
    requestMap = newValue;
  }


  HashMap initParameterMap = new HashMap();

  public Map getInitParameterMap() {
    return initParameterMap;
  }

  Locale locale = null;

  public Locale getRequestLocale() {

    log.trace("getRequestLocale  -----  ENTER ");
    if (locale != null) {
      return locale;
    }
    HttpServletRequest req = (HttpServletRequest) request;
    Locale wk =  req.getLocale();

    log.trace("getRequestLocale  => " + wk); // 2007.2.1
    
    return wk;
  }

  public void setRequestLocale(Locale newValue) {
    locale = newValue;
  }


  public Iterator getRequestParameterNames() {
    HttpServletRequest wk = (HttpServletRequest) request;
    final Enumeration namEnum = wk.getParameterNames();

    Iterator result = new Iterator() {
      /* NX */
      public boolean hasNext() {
        return namEnum.hasMoreElements();
      }

      public Object next() {
        return namEnum.nextElement();
      }

      public void remove() {
        throw new UnsupportedOperationException();
      }
    };
    return result;
  }

  Principal userPrincipal = null;
  /**
   * <p>Return the <code>Principal</code> object containing the name of
   * the current authenticated user, if any; otherwise, return
   * <code>null</code>.</p>
   */
  public Principal getUserPrincipal() {
    return userPrincipal;
  }

  public void setUserPrincipal(Principal newValue) {
    userPrincipal = newValue;
  }

  /**
   * <p>Return <code>true</code> if the currently authenticated user is
   * included in the specified role.  Otherwise, return <code>false</code>.
   * </p>
   */
  public boolean isUserInRole(String role) {

    if (rolls != null) {
      int n = rolls.length;
      for (int i = 0; i < n; i++) {
        if (role.equals(rolls[i]))
          return true;
      }
    }

    return false;

    //  return userPrincipal.getName().equals(role);
  }


  String[] rolls = null;

  public void setRolls(String[] rolls) {
    this.rolls = rolls;
  }






  /* Ql http://www.atmarkit.co.jp/fjava/rensai/j2ee07/j2ee07_3.html


public boolean isCallerAuthorized(Object securityIdentity,String [] roleNames){
  try{
    Subject subject = this.getSubject(securityIdentity);
    java.util.Set prncplsSet = subject.getPrincipals();
    java.util.Iterator prncplsIterator = prncplsSet.iterator();

    while(prncplsIterator.hasNext()){
      Principal principal = (Principal)prncplsIterator.next();
     for(int i = 0; i < roleNames.length; i++){
        if(principal.getName().equals(roleNames[i]))
        return true;
      }
    }
    return false;
  }catch(org.openejb.OpenEJBException oee){
  return false;
  // FIXME: this interface should throw   org.openejb.spi.ServiceExceptions
  }
}
   */
  public void dispatch(String requestURI) throws IOException {

    HttpServletRequest  _request  = (HttpServletRequest) request;
    HttpServletResponse _response = (HttpServletResponse) response;

    log.debug("#dispatch  requestURI " + requestURI);
    RequestDispatcher requestDispatcher = _request.getRequestDispatcher(
      requestURI);
    if (requestDispatcher == null) {
      _response.sendError( HttpServletResponse.SC_NOT_FOUND);
    }
    try {
      requestDispatcher.forward( _request, _response);
    } catch (IOException ioe) {
      throw ioe;
    } catch (ServletException se) {
      throw new FacesException(se);
    }
  }

  public String encodeActionURL(String url) {
    String wk = ((HttpServletResponse) response).encodeURL(url);
    log.debug("encodeActionURL => " + wk);
    return wk;
  }

  public String encodeNamespace(String name) {
    throw new UnsupportedOperationException();
  }

  public String encodeResourceURL(String url) {
    throw new UnsupportedOperationException();
  }

  public String getAuthType() {
    throw new UnsupportedOperationException();
  }

  public String getInitParameter(String name) {
    ServletContext sc = (ServletContext) servletContext;
    return sc.getInitParameter(name);
  }

  public String getRemoteUser() {
    throw new UnsupportedOperationException();
  }

  public String getRequestContextPath() {

    return (((HttpServletRequest) request).getContextPath());
  }

  public Map getRequestCookieMap() {
    throw new UnsupportedOperationException();
  }

  public Map getRequestHeaderMap() {
    return new MockRequestHeaderMap();
  }

  public Map getRequestHeaderValuesMap() {
    //    HttpServletRequest wk = (HttpServletRequest) request;
    //    return wk.getHeaderValuesMap();
    throw new UnsupportedOperationException();
  }

  public Iterator getRequestLocales() {
    HttpServletRequest wk = (HttpServletRequest) request;

    log.debug("getRequestLocales -----   ");

    return (new LocalesIterator(wk.getLocales()));
  }

  public String getRequestPathInfo() {
    HttpServletRequest wk = (HttpServletRequest) request;
    return wk.getPathInfo();
  }

  public String getRequestServletPath() {
    HttpServletRequest wk = (HttpServletRequest) request;
    return wk.getServletPath();
  }

  public java.net.URL getResource(String path)  {
    URL url = null;
    try {
      ServletContext wk = (ServletContext)servletContext;
      url = wk.getResource(path);
    } catch (MalformedURLException e) {
      return null;
    }
    return url;
  }

  public java.io.InputStream getResourceAsStream(String path) {
    throw new UnsupportedOperationException();
  }

  public java.util.Set getResourcePaths(String path) {
    throw new UnsupportedOperationException();
  }

  public Map getSessionMap() {
    return new SessionMap((HttpServletRequest) request);
  }

  public void log(String message) {
    throw new UnsupportedOperationException();
  }

  public void log(String message, Throwable exception) {
    throw new UnsupportedOperationException();
  }

  public void redirect(String requestURI) throws IOException {
    
    log.info("#redirect '" + requestURI + "'                  ---    _CNg");
    ((HttpServletResponse) response).sendRedirect(requestURI);
    FacesContext.getCurrentInstance().responseComplete();
  }



  /** NX */
  private class LocalesIterator implements Iterator {

    public LocalesIterator(Enumeration locales) {
      this.locales = locales;
    }

    private Enumeration locales;

    public boolean hasNext() {
      
      return locales.hasMoreElements();
    }

    public Object next() {
      Object wk = locales.nextElement();
      log.debug("LocalesIterator#next()  = '" + wk + "'         ----   ");
      return wk;
    }

    public void remove() {
      throw new UnsupportedOperationException();
    }
  }
}
