/*
 * Copyright (C) 2006 Masahito Henmi, All rights reserved.
 */
package dwarf.jsf.context;

import dwarf.MockConstants;
import java.io.*;
import java.util.*;
import javax.servlet.http.HttpServletRequest;
/**
 */
public class RequestParameterMap extends Hashtable {

  static final long serialVersionUID = 1928921920861066142L;


  public  void setData(Object oreq) throws IOException {

     HttpServletRequest req = (HttpServletRequest) oreq;
    _getParameters(this, req);

    this.put(MockConstants.REQUEST_SCHEME, req.getScheme());
    this.put(MockConstants.REQUEST_HOST, "" + req.getHeader("Host")); // null΍

    this.put(MockConstants.REQUEST_URI, req.getRequestURI());
  }
  
  /**
   *
   */
  private  void _getParameters(Map af, HttpServletRequest req) throws IOException {
    Enumeration e = req.getParameterNames();
    while (e.hasMoreElements()) {
      String key = (String) e.nextElement();
      String[] values = req.getParameterValues(key);
      String userIn = new String(values[0].getBytes("8859_1"), "MS932");
      af.put( key , removeControlCode(userIn));
    }
  }

  /** R[h<br>
      R[hECWFNVȖ΍ */
  private  String removeControlCode(String in) {
  
    StringBuffer sb = new StringBuffer();
    int n = in.length();
    for (int i = 0; i < n; i++) {
      char c = in.charAt(i);
      if (c == 0x7f) {
      } else if ('\0' <= c && c < ' ') {
      } else {
        sb.append(c);
      }
    }
    return sb.toString();
  }

  





  /*
  private String viewId = null;

  public String getViewId() {

    return (this.viewId);
  }

  public void setViewId(String viewId) {

    this.viewId = viewId;
  }

  String html = null;

  public String getHtml() {
    return html;
  }

  public void setHtml(String newValue) {
    html = newValue;
  }
  */
}
