/*
 * Copyright (C) 2006 Masahito Henmi, All rights reserved.
 */
package dwarf.view;

import java.io.*;
import java.util.*;
import org.apache.commons.logging.*;
/**
 *    񏑂ResponseWriterWithJavaScript
 */
public class StringResponseWriter extends ResponseWriterWithJavaScript {
  
  private static final Log log = LogFactory.getLog(StringResponseWriter.class);

  Writer writer = new StringWriter();
  Sanitizer sanitizer = null;
  Hashtable notCloseHt = new Hashtable();

  
  /** RXgN^ */
  public StringResponseWriter() {
    sanitizer = new Sanitizer();
    initHashtable();
  }
  
  /** RXgN^ */
  public StringResponseWriter(Sanitizer sanitizer) {
    this.sanitizer = sanitizer;
    initHashtable();
  }

  private void initHashtable() {
    notCloseHt.put("input", "input");
  }

  

  boolean openFlag = false;

  public void closeIfNecessary() throws java.io.IOException {

    if (openFlag) {
      writer.write(">");
      openFlag = false;
    }
  }
  
  public void endElement(String name) throws java.io.IOException {

    log.trace("endElement");
    
    closeIfNecessary();

    if (notCloseHt.get(name) != null) return;
    
    writer.write("</");
    writer.write(name);
    writer.write(">");
  }
  
  public void flush() throws java.io.IOException {

    closeIfNecessary();
    log.trace("flush");
  }
  
  
  public void startElement(String name, javax.faces.component.UIComponent component) throws java.io.IOException {
    
    log.trace("startElement");

    closeIfNecessary();
    writer.write("<");
    writer.write(name);
    openFlag = true;
  }
  
  public void write(String msg) throws java.io.IOException {
    
    closeIfNecessary();
    log.trace("write");
    writer.write(msg); // Tj^CYȂ
  }

  public void setQuoteCharacter(String qChar) {
    quote = qChar;
  }

  String quote = "\"";

  
  public void writeAttribute(String name, Object value, String property) throws java.io.IOException {
    
    log.trace("writeAttribute");
    writer.write(" ");
    writer.write(name);
    writer.write("=");
    writer.write(quote);

    if (isJavaScriptAttribute(name)) {
      writer.write(value.toString());
    } else {
      writer.write(sanitizer.encode(value.toString()));
    }
    writer.write(quote);
  }


  public boolean isJavaScriptAttribute(String name) {

    return "onfocus".equalsIgnoreCase(name) || "onblur".equalsIgnoreCase(name);
  }



  
  public void writeText(Object text, String property) throws java.io.IOException {
    
    closeIfNecessary();
    log.trace("writeText");
    writer.write(sanitizer.encode(text.toString()));
  }
  
  public void writeURIAttribute(String name, Object value, String property) throws java.io.IOException {
    
    log.trace("writeURIAttribute");
    writer.write(" ");
    writer.write(name);
    writer.write("=\"");
    String url = sanitizer.encodeURL(value.toString());
    log.trace("url = " + url);
    writer.write(url);
    writer.write("\"");
  }
  

  /** ʂ𕶎ŕԂ */
  public String toString() {

    String ans = null;
    if (writer instanceof StringWriter) {
      StringWriter sw = (StringWriter) writer;
      ans = sw.toString();
    }
    return ans;
  }

  // ---------------------------------------

  Hashtable scriptHash = new Hashtable();
  
  
  public void writeJavaScript(String type, String msg) throws java.io.IOException {

    Writer wri = (Writer) scriptHash.get(type);
    if (wri == null) {
      wri = new StringWriter();
      scriptHash.put(type, wri);
    }
    wri.write(msg);
  }

  public String getScript(String type) {
    String ans = null;
    Writer scriptWriter = (Writer) scriptHash.get(type);
    if (scriptWriter != null && scriptWriter instanceof StringWriter) {
      StringWriter sw = (StringWriter) scriptWriter;
      ans = sw.toString();
    }
    return ans;
  }
  
  public void close() throws IOException {
  }  

  public void endDocument() throws java.io.IOException {
  }
  
  public javax.faces.context.ResponseWriter cloneWithWriter(java.io.Writer writer) {
    return null;
  }
  
  public void write(char[] cbuf, int off, int len) throws IOException {
    writer.write(cbuf, off, len);
  }
  
  public String getContentType() {
    return null;
  }
  
  public void writeComment(Object obj) throws java.io.IOException {
  }
  
  public void startDocument() throws java.io.IOException {
  }
  
  public void writeText(char[] values, int param, int param2) throws java.io.IOException {
  }
  
  public String getCharacterEncoding() {
    return null;
  }
  
}
