package strawberry.configure;

import com.sun.faces.application.ConfigNavigationCase;
import com.sun.faces.config.*;
import com.sun.faces.config.beans.*;
import javax.faces.application.NavigationHandler;
import javax.servlet.ServletContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import strawberry.application.ApplicationAssociate;
/**
 * <p>Parse all relevant JavaServer Faces configuration resources, and
 * configure the Reference Implementation runtime environment.</p>
 * <p/>
 */
public class ConfigureListenerEx /*implements ServletContextListener*/ {

  static final Log log = LogFactory.getLog(ConfigureListenerEx.class);

  public void configure(ServletContext servletContext, FacesConfigBean config)  throws Exception {

    configure( servletContext, config.getManagedBeans());
  }

  public void configure(ServletContext servletContext, ManagedBeanBean[] mConf)  throws Exception {

    log.debug("(47) -------------- configure Jn");
    
    ApplicationAssociate associate =  new ApplicationAssociate();
    
    configure(mConf, associate);

    servletContext.setAttribute(ApplicationAssociate.ASSOCIATE_KEY, associate);

    /* 2007.2.11 폜 */
    //  NavigationHandler쐬邽߂ɁA擾\bhĂ
    //NavigationHandler navHand = application.getNavigationHandler();
    //configureNavigationRules(navHand, impl.getApplicationAssociate());
    
    log.debug("(72) -------------- configure I");
  }
  public void configureNavigationRules(NavigationHandler navHand, ApplicationAssociate associate) {
    if (navHand == null) {
      log.error ("navHand == null");
      return;
    }

    NavigationRuleBean rule1 = new NavigationRuleBean();

    NavigationCaseBean rule1case1 = new NavigationCaseBean();
    rule1case1.setFromAction("/par/FPage12");
    rule1case1.setFromOutcome("success");
    rule1case1.setRedirect(true);
    rule1case1.setToViewId("/servlet/MainMenuServlet");
    rule1.addNavigationCase(rule1case1);


    NavigationRuleBean rule2 = new NavigationRuleBean();

    NavigationCaseBean rule2case1 = new NavigationCaseBean();
    rule2case1.setFromAction("*"); ////////
    rule2case1.setFromOutcome("success");
    rule2case1.setRedirect(true);
    rule2case1.setToViewId("/servlet/MainMenuServlet");
    rule2.addNavigationCase(rule2case1);

    NavigationRuleBean[] arr = new NavigationRuleBean[] { rule1, rule2 };

    configure(arr, associate);
  }

  private void configure(NavigationRuleBean config[], ApplicationAssociate associate) {

    if (config == null) {
      return;
    }
    
    if (null == associate) {
      return;
    }

    for (int i = 0; i < config.length; i++) {
      if (log.isTraceEnabled()) {
        log.trace("addNavigationRule(" +
                  config[i].getFromViewId() + ')');
      }
      NavigationCaseBean ncb[] = config[i].getNavigationCases();
      for (int j = 0; j < ncb.length; j++) {
        if (log.isTraceEnabled()) {
          log.trace("addNavigationCase(" +
                 ncb[j].getFromAction() + ',' +
                 ncb[j].getFromOutcome() + ',' +
                 ncb[j].isRedirect() + ',' +
                 ncb[j].getToViewId() + ')');
        }
        ConfigNavigationCase cnc = new ConfigNavigationCase();
        if (config[i].getFromViewId() == null) {
          cnc.setFromViewId("*");
        } else {
          cnc.setFromViewId(config[i].getFromViewId());
        }
        cnc.setFromAction(ncb[j].getFromAction());
        String fromAction = ncb[j].getFromAction();
        if (fromAction == null) {
          fromAction = "-";
        }
        cnc.setFromOutcome(ncb[j].getFromOutcome());
        String fromOutcome = ncb[j].getFromOutcome();
        if (fromOutcome == null) {
          fromOutcome = "-";
        }
        cnc.setToViewId(ncb[j].getToViewId());
        String toViewId = ncb[j].getToViewId();
        if (toViewId == null) {
          toViewId = "-";
        }
        cnc.setKey(cnc.getFromViewId() + fromAction + fromOutcome);
        if (ncb[j].isRedirect()) {
          cnc.setRedirect("true");
        } else {
          cnc.setRedirect(null);
        }
        associate.addNavigationCase(cnc);
      }
    }
  }

  Class managedBeanFactoryClass = null;

  private void setManagedBeanFactoryClass(Class clazz) {
    managedBeanFactoryClass = clazz;
  }

  public void setManagedBeanFactoryClass(String className) {
    //  typeɉāAClassLoadeřo@ς
    try {
      managedBeanFactoryClass = Class.forName(className);
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }
  }  
  
  
  public void configure(ManagedBeanBean config[], ApplicationAssociate associate) throws Exception {
    if (config == null) {
      return;
    }

    if (null == associate) {
      log.error("(62) return associate is null  !! ");
      return;
    }

    for (int i = 0; i < config.length; i++) {
      log.trace("addManagedBean(" + config[i].getManagedBeanName() + ',' + config[i].getManagedBeanClass() + ')');

      ManagedBeanFactory mbf = (ManagedBeanFactory) managedBeanFactoryClass.newInstance();
      mbf.setManagedBeanBean(config[i]);

      associate.addManagedBeanFactory(config[i].getManagedBeanName(),  mbf);
    }
  }
}
