package strawberry.configure;

import com.sun.faces.modify.*;
import java.util.*;
import javax.servlet.ServletContext;
import com.sun.faces.config.*;
import com.sun.faces.config.beans.FacesConfigBean;

import com.sun.faces.config.beans.ManagedBeanBean;
import strawberry.application.ApplicationAssociate;

import org.apache.commons.logging.*;

/**
 * Created on 2007.2.2
 *
 *   ̕ύX FacesConfigFactory => ManagedBeanXml
 */
public class ManagedBeanXml {

  static final Log log = LogFactory.getLog(ManagedBeanXml.class);

  static Hashtable hash = new Hashtable();


  public static void processXml(String xmlPath, ServletContext sc, String type) throws Exception {

    ConfigureListenerEx cl = new ConfigureListenerEx();

    log.info("processXml --- ܂ " + xmlPath);
    FacesConfigBean configBean = ManagedBeanXml.getFacesConfigBean(xmlPath);

    //  typeɉāAClassLoadeřo@ς
    cl.setManagedBeanFactoryClass(type);
    cl.configure(sc, configBean);
    // ServletContextɍꂽApplicationAssociateۑ
  }

  public static void addAnotherXml(String xmlPath2, ServletContext sc, String type) throws Exception {

    log.info("addAnotherXml --- ܂ " + xmlPath2);
    ConfigureListenerEx cl = new ConfigureListenerEx();

    FacesConfigBean configBean2 = ManagedBeanXml.getFacesConfigBean(xmlPath2);

    //  typeɉāAClassLoadeřo@ς
    cl.setManagedBeanFactoryClass(type);

    ManagedBeanBean[] config = configBean2.getManagedBeans();

    // ServletContextAOꂽApplicationAssociateo
    ApplicationAssociate associate = ApplicationAssociate.getInstance(sc);
    
    cl.configure(config, associate);

    if (log.isDebugEnabled()) {
      log.debug("addAnotherXml, config = " + config);
      log.debug("addAnotherXml, associate = " + associate);
      log.debug("addAnotherXml,  managedBeanFactories.size() = " +  associate.getManagedBeanFactoriesSize());
    }
  }

  /**
   *
   */
  public static synchronized FacesConfigBean getFacesConfigBean(String path) {

    Object wk = hash.get(path);
    if (wk != null) {
      log.info("(64) FacesConfigBean LbVɌ̂łԂ");
      return (FacesConfigBean) wk;
    }
    
    FacesConfigLoaderEx loader = new FacesConfigLoaderEx();
    FacesConfigBean bean = loader.load(path);
    hash.put(path, bean);
    log.info("(70) FacesConfigBean VK쐬ăLbVɓo^");
    return bean;
  }
}
