/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
#include <cmath>

// BVDIST computes distance of two points P1 and P2. 
// INPUT *** NCD is the space dimension of the two points P1 
//           and P2. 
//           P1(NCD), P2(NCD)....two points. 
// OUTPUT *** BVDIST : DISTANCE OF P1 AND P2. 
double bvdist_(int ncd,const double *p1,const double *p2){
    int i;
    double r, r1;
    r = 0.f;
    for(i=0; i<ncd; ++i){
		r1 = p1[i]-p2[i];
		r += r1*r1;
    }
    return  sqrt(r);
}
