/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
#include "StdAfx.h"
#include "mg/Box.h"
#include "mg/BPointSeq.h"
#include "mg/Knot.h"
#include "mg/Curve.h"
#include "mg/Ellipse.h"
#include "mg/LBRep.h"
#include "mg/RLBRep.h"
#include "mg/Straight.h"
#include "mg/Tolerance.h"

#if defined(_DEBUG)
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
	
///B\ȐXgڑ(LBRep, RLBRepm̂)Bjoin_crvlɐڑȐXgB
///߂ĺA̋ȐXǧႤƂAB\młȂƂfalseԂB
int join(std::vector<UniqueCurve>& crvl, std::vector<UniqueCurve>& join_crvl);

// Implementation of curve offset.

#define POW_LOW 0.34	//ŏɃItZbg|Cg߂W(xd)
#define POW_HIGH 0.50   //ŏɃItZbg|Cg߂W(xd)
#define NUM_DIV 50      //1Xp̕zƂPOW_LOWgp悤ɂ

//2{B\Ȑڑ(ނ̂Ƃ)
MGLBRep* join2LBRep(const MGLBRep& crv1, const MGLBRep& crv2){
	int which, cont;
	double ratio;
	cont = crv1.continuity(crv2, which, ratio);
	if(cont < 0 || which == 0 || which == 3)
		return NULL;

	auto lb=new MGLBRep(crv1);
	lb->connect(cont, which, crv2);
	return lb;
}

//ItZbg֐
//ItZbǵA@猩ē͋Ȑ̐is𐳂ƂB
//@xNgk̏ꍇAn_ɂċȗS𐳂ƂB
//AȗS֋ȗaȏ̃ItZbg͍sȂBgXline_zero()gpĂB
//߂ĺAItZbgȐXgԋpB
std::vector<UniqueCurve> MGCurve::offset(
	double ofs_value,			//ItZbg
	const MGVector& norm_vector	//@xNg
)const{
	MGBPointSeq bp1(2, 1);					//ofs_value̒𐶐
	bp1.store_at(0, &ofs_value);
	bp1.store_at(1, &ofs_value);
	MGLBRep ofs_value_lb;
	ofs_value_lb.buildByInterpolation(bp1, 2);	//I[_[Q̒
	ofs_value_lb.change_range(param_s(), param_e());
	return offset(ofs_value_lb, norm_vector);	//σItZbggp
}

//σItZbg֐
//ItZbgʂ͋Ԏ1̐B\ŗ^B
//ItZbǵA@猩ē͋Ȑ̐is𐳂ƂB
//@xNgk̏ꍇAn_ɂċȗS𐳂ƂB
//AȗS֋ȗaȏ̃ItZbg͍sȂBgXline_zero()gpĂB
//߂ĺAItZbgȐXgԋpB
std::vector<UniqueCurve> MGCurve::offset(
	const MGLBRep& ofs_value_lb,	//ԎP̐B\ŎItZbg
	const MGVector& norm_vector		//@xNg
)const{
	std::vector<UniqueCurve> ofs_crvl;
	if(norm_vector == mgNULL_VEC){
		offset_proc(ofs_value_lb, ofs_crvl);
	}else{
		offset_norm_proc(ofs_value_lb, norm_vector, ofs_crvl);
	}
	return ofs_crvl;
}

//ItZbg֐
//ItZbǵA@猩ē͋Ȑ̐is𐳂ƂB
//@xNgk̏ꍇAn_ɂċȗS𐳂ƂB
//AȗS֋ȗaȏ̃ItZbg͍sȂBgXline_zero()gpĂB
//߂ĺAItZbgȐԋpB
std::vector<UniqueCurve> MGStraight::offset(
	double ofs_value,			//ItZbg
	const MGVector& norm_vector	//@xNg
)const{
	std::vector<UniqueCurve> ofs_crvl;
	MGStraight *st1 = clone();
	if(norm_vector == mgNULL_VEC){
		*st1 += MGUnit_vector() * ofs_value;
	}else{
		MGUnit_vector tangent = st1->direction(param_s()), ofs_dir;
		ofs_dir = norm_vector * tangent;
		*st1 += ofs_dir * ofs_value;
	}
	ofs_crvl.emplace_back(st1);
	return ofs_crvl;
}

//@xNgw肳ĂƂ̏
int MGCurve::offset_norm_proc(
	const MGLBRep& ofs_value_lb,	//ItZbg
	const MGVector& norm_vector,	//@xNg
	std::vector<UniqueCurve>& ofs_crvl	//ItZbgJ[uXg
)const{
	//Ȑ܂ꂪimultiple knotjŕ
	std::vector<UniqueCurve> crv_list, tmp_list;
	int nDiv = divide_multi_ofs(ofs_value_lb, crv_list);

	ofs_crvl.clear();
	for(int i = 0;i < nDiv; i++){
		MGLBRep tmp_brep;
		if(!crv_list[i]->offset_norm_c2_proc(ofs_value_lb, norm_vector, tmp_brep))
			return false;
		tmp_list.emplace_back(tmp_brep.clone());
	}
	int num = join(tmp_list, ofs_crvl);
	return num;
}

//@xNgw肳ĂȂƂ̏
int MGCurve::offset_proc(
	const MGLBRep& ofs_value_lb,		//ItZbg
	std::vector<UniqueCurve>& ofs_crvl	//ItZbgJ[uXg
)const{
	//Ȑ܂imultiple knotjŕ
	std::vector<UniqueCurve> crv_list, tmp_list;
	int nDiv = divide_multi_ofs(ofs_value_lb, crv_list);

	ofs_crvl.clear();
	MGUnit_vector T, B, preN;	//preN : Õm[}xNg
	int freverse = 0;			//tɂĂƂtO
	double curvature, torsion;
	Frenet_frame(param_s(), T, preN, B, curvature, torsion);	//J[un_̃m[}ŏɗ^

	for(int i = 0;i < nDiv; i++){
		UniqueLBRep tmp_brep(new MGLBRep);
		if(!crv_list[i]->offset_c2_proc(ofs_value_lb, *tmp_brep, preN, freverse))
			return false;
		tmp_list.push_back(std::move(tmp_brep));
	}
	int num = join(tmp_list, ofs_crvl);
	return num;
}

//C2AȐ̈ItZbg֐
//ItZbǵA@猩ē͋Ȑ̐is𐳂ƂB
//@xNgk̏ꍇAn_ɂċȗS𐳂ƂB
//AȗS֋ȗaȏ̃ItZbg͍sȂBgXline_zero()gpĂB
//߂ĺAItZbgȐԋpB
MGLBRep MGCurve::offset_c2(
	double ofs_value,				//ItZbg
	const MGVector& norm_vector		//@xNg
)const{
	MGBPointSeq bp1(2, 1);					//ofs_value̒𐶐
	bp1.store_at(0, &ofs_value);
	bp1.store_at(1, &ofs_value);
	MGLBRep ofs_value_lb;
	ofs_value_lb.buildByInterpolation(bp1, 2);//I[_[Q̒
	ofs_value_lb.change_range(param_s(), param_e());
	return offset_c2(ofs_value_lb, norm_vector);	//σItZbggp
}

//C2AȐ̉σItZbg֐
//ItZbgʂ͋Ԏ1̐B\ŗ^B
//ItZbǵA@猩ē͋Ȑ̐is𐳂ƂB
//@xNgk̏ꍇAn_ɂċȗS𐳂ƂB
//AȗS֋ȗaȏ̃ItZbg͍sȂBgXline_zero()gpĂB
//߂ĺAItZbgȐԋpB
MGLBRep MGCurve::offset_c2(
	const MGLBRep& ofs_value_lb,	//ԎP̐B\ŎItZbg
	const MGVector& norm_vector		//@xNg
)const{
	int rc = 0;
	MGLBRep ofs_brep;
	if(norm_vector == mgNULL_VEC){
		int freverse = 0;			//tɂĂƂtO
		MGUnit_vector T, B, preN;	//preN : Õm[}xNg
		double curvature, torsion;
		Frenet_frame(param_s(), T, preN, B, curvature, torsion);	//J[un_̃m[}ŏɗ^
		rc = offset_c2_proc(ofs_value_lb, ofs_brep, preN, freverse);
	}else{
		rc = offset_norm_c2_proc(ofs_value_lb, norm_vector, ofs_brep);
	}
	if(!rc)return MGLBRep();
	ofs_brep.remove_knot();
	return ofs_brep;
}

//@xNgw肳ĂC2AȐ̃ItZbg
int MGCurve::offset_norm_c2_proc(
	const MGLBRep& ofs_value_lb,//ItZbg
	const MGVector& norm_vector,//@xNg
	MGLBRep& ofs_brep			//ItZbgJ[u
)const{
	MGKnotVector& t=ofs_brep.knot_vector();
	t = offset_make_knotvector(ofs_value_lb);	//\mbgxNg߂
	MGNDDArray dataPoint;
	dataPoint.buildByKnotVector(t);

	//_𐶐
	int len = dataPoint.length();
	MGBPointSeq bp1(len, sdim());
	for(int i = 0; i < len; i++){
		MGUnit_vector T, N, B, ofs_dir;
		double curvature, torsion, ofs_value = ofs_value_lb.eval_position(dataPoint(i)).ref(0);
		Frenet_frame(dataPoint(i), T, N, B, curvature, torsion);
		ofs_dir = norm_vector * T;
		double cosine = N % ofs_dir;
		int fneg = (cosine < 0);	//RTC̐tO
		if(!MGMZero(curvature))		//[`FbN
			if((ofs_value * (-2. * fneg + 1)) > ((1. / curvature) / fabs(cosine)))return false;
		MGPosition pos;
		pos = eval(dataPoint(i));
		pos += ofs_dir * ofs_value;
		bp1.store_at(i, pos);
	}
	//mbgxNg߂ăItZbgȐ𐶐
	ofs_brep.buildByInterpolationWithKTV(dataPoint, bp1);//x\̋Ȑ𐶐
	return true;
}

//@xNgw肳ĂȂC2AȐ̃ItZbg
int MGCurve::offset_c2_proc(
	const MGLBRep& ofs_value_lb,	//ItZbg
	MGLBRep& ofs_brep,			//ItZbgJ[u
	MGUnit_vector& preN,		//Õm[}xNg
	int& freverse			//tɂĂƂtO
)const{
	MGKnotVector knotVector = offset_make_knotvector(ofs_value_lb);	//\mbgxNg߂
	MGNDDArray dataPoint;
	dataPoint.buildByKnotVector(knotVector);

	//_𐶐
	int len = dataPoint.length();
	MGBPointSeq bp1(len, sdim());
	for(int i = 0; i < len; i++){
		MGUnit_vector T, N, B;
		double curvature, torsion, ofs_value = ofs_value_lb.eval_position(dataPoint(i)).ref(0);
		Frenet_frame(dataPoint(i), T, N, B, curvature, torsion);
		if(MGMZero(curvature))
			N = preN;		//ȗƂm[}͑Ôg

		//m[}SɂȂ悤ɂ(180xȏJȂ)
		if((preN % N) < 0)
			freverse = !(freverse);
		int fdir = -2 * freverse + 1;	//freversefalsêƂ1, truêƂ-1
		if(!MGMZero(curvature))	//[`FbN
			if(ofs_value*fdir > (1./curvature))
				return false;//ȗa傫ItZbg͔F߂Ȃ
		preN = N;	//m[}Ă
		MGPosition pos;
		pos = eval(dataPoint(i));
		pos += fdir * N * ofs_value;
		bp1.store_at(i, pos);
	}

	//mbgxNg߂ăItZbgȐ𐶐
	ofs_brep.setKnotVector(std::move(knotVector));
	ofs_brep.buildByInterpolationWithKTV(dataPoint, bp1);	//x\̋Ȑ𐶐
	return true;
}

//Ȑ܂ŕ(ItZbgʂȐ̐܂Ă)
int MGCurve::divide_multi_ofs(
	const MGLBRep& ofs_value_lb,		//ItZbgʂȐ
	std::vector<UniqueCurve>& crv_list	//divided curves are set.
)const{
	crv_list.clear();
	//ItZbgʂȐƌ̋Ȑ̃p[^WႤƃG[
	if(param_range() != ofs_value_lb.param_range())return 0;
	int	start_index = ofs_value_lb.order() - 1, index = 0, count = 0, multi = 0, vbdim = ofs_value_lb.bdim();
	MGKnotVector value_knot = ofs_value_lb.knot_vector();
	do{
		if(ofs_value_lb.order() == 2){	//I[_[2̂Ƃ̏
			index = start_index + 1; multi = 1;
		}else{
			multi = value_knot.locate_multi(start_index, 2, index);
		}
		MGCurve *temp_crv = part(value_knot(start_index), value_knot(index));
		count += temp_crv->divide_multi(crv_list);
		delete temp_crv;
		start_index = index + multi - 1;
	}while(index != vbdim && value_knot(start_index) < param_e());	//dxȂI
	return count;
}

//1Xp̕߂
int MGCurve::offset_div_num(
	const MGInterval& interval	//߂p[^͈
)const{
	//Qorder()ŕčő2l߂
	int ord = order();
	if(ord<=2)
		ord = 4;		//Ellipse, Straight̂Ƃ
	int ord2=ord*2;
	double max_deriv = 0.0, tpara = interval.low_point();
	double shortspan = (interval.high_point() - tpara)/ord2;
	double oneSpanLength = interval.length();
	double oneSpanLength2=oneSpanLength*oneSpanLength;
	for(int j = 0; j <=ord2; j++){
		//p[^͈(0,1)2lɒ߂Ƀp[^͈͂2
		double deriv = eval(tpara, 2).len() * oneSpanLength2;
		if(deriv > max_deriv) max_deriv = deriv;
		tpara += shortspan;
	}

	double onelzero=1./MGTolerance::line_zero();
	// (1 / tol)^POW * sqrt(max_deriv / 8)ōŏl order()ł
	double sqrt_max_deriv8=sqrt(max_deriv / 8.);
	int ndiv = int(pow(onelzero, POW_HIGH) * sqrt_max_deriv8);
	if(ndiv > NUM_DIV)
		ndiv = int(pow(onelzero, POW_LOW) * sqrt_max_deriv8);
	if(ndiv < ord2)
		ndiv = ord2;
	else if(ndiv > NUM_DIV*2)
		ndiv=NUM_DIV*2;
	return ndiv;
}

//B\ȐXgڑ(LBRep̂)Bjoin_crvlɐڑȐXgB
//߂ĺA̋ȐXǧႤƂAB\młȂƂfalseԂB
int join(
	std::vector<UniqueCurve>& crvl,
	std::vector<UniqueCurve>& join_crvl
){
	int num = (int)crvl.size(), rc = 0;
	MGCurve *pre_pcrv = 0, *cur_pcrv, *next_pcrv;
	if(!num)
		return false;

	if(num == 1){	//ȐP{̂Ƃ̏
		cur_pcrv = crvl[0]->clone();
		cur_pcrv->remove_knot();
		join_crvl.emplace_back(cur_pcrv);
		return 1;
	}

	cur_pcrv = crvl[0]->clone();
	for(int i = 0; i < num - 1; i++){
		next_pcrv = crvl[i+1].get();
		if(!cur_pcrv || !next_pcrv)
			return false;

		MGLBRep* lb1=dynamic_cast<MGLBRep*>(cur_pcrv);
		MGLBRep* lb2=dynamic_cast<MGLBRep*>(next_pcrv);
		if(!lb1 || !lb2)
			return false;

		pre_pcrv = join2LBRep(*lb1,*lb2);
		if(!pre_pcrv){
			rc++;
			cur_pcrv->remove_knot();
			join_crvl.emplace_back(cur_pcrv);
			delete pre_pcrv;
			cur_pcrv = next_pcrv->clone();
			continue;
		}
		delete cur_pcrv;
		cur_pcrv = pre_pcrv;
	}
	cur_pcrv->remove_knot();
	join_crvl.emplace_back(cur_pcrv);
	rc++;
	return rc;
}

//ȐItZbĝɏ\mbgxNgԋp
//ItZbgʋȐlɓȂɂ킹ĂB
MGKnotVector MGCurve::offset_make_knotvector(
	const MGLBRep& ofs_value_lb
)const{
	//ƂȂmbgxNg𐶐
	const MGKnotVector& tempKnotVector = knot_vector();
	MGKnotVector knotVector(tempKnotVector, 4);	//I[_[4̃mbgxNgɍւ
	for(int i=tempKnotVector.order()-1; i<tempKnotVector.bdim(); i++){
		double	tpara = 0.0,					//e|
				spara = tempKnotVector(i),		//Xp̎n_
				epara = tempKnotVector(i + 1);	//Xp̏I_
		if(epara - spara < param_error())
			continue;	//}`mbĝƂ̏(RLBRep̂)

		//1Xp̕肷
		MGInterval interval(spara, epara);
		int ndiv = offset_div_num(interval),					//ItZbgȐ̕
			tmp_ndiv = ofs_value_lb.offset_div_num(interval);	//ItZbgʋȐ̕
		if(tmp_ndiv>ndiv)
			ndiv=tmp_ndiv;						//̑p
		double shortspan = (epara - spara) / ndiv;
		tpara = spara;
		for(int j=0; j<ndiv; j++){
			knotVector.add_data(tpara);
			tpara += shortspan;
		}
	}
	return knotVector;
}
