/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
#include "StdAfx.h"
#include "mg/tolerance.h"
#include "mg/OfStream.h"
#include "mg/IfStream.h"
#include "mg/MGStl.h"
#include "mgGL/Image.h"

// t@C̎ނ𒲂ׂ
// in[in]Ft@CXg[
// ߂lFoCit@C(true)AAsciit@C(false)
// OFłɃI[vĂt@CXg[n
bool IsBinaryFile(
	 std::ifstream& in // [in/out]:ɃI[vĂt@CXg[
){
	char buff[85];
	in.read(buff, 85);
	size_t readByte = (size_t)in.gcount();
	for(size_t i = 80; i < readByte; i++){
		if(buff[i] == 0){
			// V[Nʒut@C̐擪ɖ߂
			in.seekg(0, std::ios::beg);
			return true;
		}
	}
	// V[Nʒut@C̐擪ɖ߂
	in.seekg(0, std::ios::beg);
	return false;
}

//constructor from triangle data, index+vertices 
MGStl::MGStl(
	int nTriang, // Op`̐
	const int* triang, // _W̃CfbNX̔z
	const double* verts // _̍W
){
	// Keep vertex position and index of vertex
	triangleMap VertexMap;
	// index of vertex
	int i0, i1, i2;
	for(int j = 0; j < nTriang; j++){
		int j3 = 3 * j;
		// Get index of cordinate of vertex
		i0 = triang[j3++] - 1;
		i1 = triang[j3++] - 1;
		i2 = triang[j3] - 1;
		// Get cordinate of vertex
		const MGPosition pos1(3, verts+3*i0); m_box.expand(pos1);
		const MGPosition pos2(3,verts+3*i1); m_box.expand(pos2);
		const MGPosition pos3(3,verts+3*i2); m_box.expand(pos3);
		push_back_triangle(pos1, pos2, pos3, VertexMap);
	}
}

///Constructor from triangle data, index+vertices.
///This constructor uses the wc_zero to identify
///different two positions as the same input position.
MGStl::MGStl(
	const std::vector<MGPosition>& vertices,/// trang[id0], [id1], [id2] make
		//a triangle for id0=indices[i*3], id1=indices[i*3+1], id2=indices[i*3+2]
		//for i=0,...,indices.size()/3.
	const std::vector<int>& indices /// _id.
		//(0,1,2),...(i*3, i*3+1, i*3+2) for i=0,...,indices.size()/3.
){
	// Keep vertex position and index of vertex
	triangleMap VertexMap;

	size_t nTriang=indices.size()/3;
	// index of vertex
	size_t i0, i1, i2;
	for(size_t j=0; j<nTriang; j++){
		size_t j3 = j*3;

		// Get index of cordinate of vertex
		i0 = indices[j3++] - 1;
		i1 = indices[j3++] - 1;
		i2 = indices[j3] - 1;
		// Get cordinate of vertex
		const MGPosition& pos1=vertices[i0]; m_box.expand(pos1);
		const MGPosition& pos2=vertices[i1]; m_box.expand(pos2);
		const MGPosition& pos3=vertices[i2]; m_box.expand(pos3);
		push_back_triangle(pos1, pos2, pos3, VertexMap);
	}
}

// SĂ̒_ƃ{bNX̍WɎw肵MGVector̒lZ
MGStl& MGStl::operator+=(const MGVector& v){
	size_t nPos = m_vecPos.size();
	for(size_t i = 0; i < nPos; i++){
		m_vecPos[i] += v;
	}
	m_box += v;
	return *this;
}

// SĂ̒_ƃ{bNX̍Ww肵MGVector̒l
MGStl& MGStl::operator-=(const MGVector& v){
	size_t nPos = m_vecPos.size();
	for(size_t i = 0; i < nPos; i++){
		m_vecPos[i] -= v;
	}
	m_box -= v;
	return *this;
}

// SĂ̒_ƃ{bNX̍WɎw肵l|
MGStl& MGStl::operator*=(double scale){
	size_t nPos = m_vecPos.size();
	for(size_t i = 0; i < nPos; i++){
		m_vecPos[i] *= scale; 
	}
	m_box *= scale;
	return *this;
}

// ^ꂽϊs
MGStl& MGStl::operator*=(const MGMatrix& mat){
	size_t nVecPos = m_vecPos.size();
	for(size_t i = 0; i < nVecPos; i++){
		m_vecPos[i] *= mat;
	}
	size_t nVecTriang = m_vecNormlTriang.size();
	for(size_t j = 0; j < nVecTriang; j++){
		m_vecNormlTriang[j] *= mat;
	}
	m_box *= mat;
	return *this;
}

// ^ꂽϊɂgXtH[s
MGStl& MGStl::operator*=(const MGTransf& tr){
	size_t nPos = m_vecPos.size();
	for(size_t i = 0; i < nPos; i++)	{
		m_vecPos[i] *= tr;
	}
	size_t nVecTriang = m_vecNormlTriang.size();
	for(size_t j = 0; j < nVecTriang; j++)	{
		m_vecNormlTriang[j] *= tr.affine();
	}
	m_box *= tr;
	return *this;
}

// MGStlIuWFNgr
bool MGStl::operator==(const MGStl& stl){
	// {bNXg̔r
	if(this->m_box != stl.m_box)
		return false;

	// W̔r
	if(m_vecPos != stl.m_vecPos){
			return false;
	}

	// ʂ̖@xNg̔r
	if(m_vecNormlTriang != stl.m_vecNormlTriang){
		return false;
	}

	if(m_indices != stl.m_indices){
		return false;
	}

	// vĂꍇtrueԋp
	return true;
}

//Construct new object by copying to newed area.
//User must delete this copied object by "delete".
MGStl* MGStl::clone()const{
	return new MGStl(*this);
}

// w肵Op`̒_WĂz̃CfbNX擾
// O:0Op`̖-1𒴂͈͂̒lPɎw肵Ȃ
// :pos[3]Ɏw肵Op`̊e_W̔z̓Yi[
void MGStl::GetVertIndices(
	 int i,// [in]FOp`̃CfbNX(0 <= i < GetTriangleCount)
	 int pos[3]// [out]Fw肵Op`̊e_W̔z̓Y[i, j, k]
)const{
	// w肵Op`̒_ԍ̔z̃CfbNX߂Ă
	int i3 = i*3;
	assert(size_t(i3+2) < m_indices.size());

	// _W̃CfbNX
	pos[0] = m_indices[i3++];
	pos[1] = m_indices[i3++];
	pos[2] = m_indices[i3];
}

///Compute box of the geometry.
///Compute the box from the scratch.
void MGStl::compute_box(MGBox& bx) const{
	bx.set_null();
	for(auto& P: m_vecPos)
		bx.expand(P);
}

// Ŏw肵pXSTLt@Cǂݍ݃oɒlݒ肷
// ܂MGTolerance::wc_zeroɒlݒ肷
// ߂l: =0t@C̓ǂݍ
//		  !=0 ǂݍ܂ȂB܂͎s(std::ifstream̃G[R[hj
// :m_vecPos, m_vecNorml, m_indices, m_boxɐ}`̏񂪊i[
//			MGTolerance::wc_zeroɒlݒ肳
int MGStl::LoadFile(
	const TCHAR* strFilePath // [in]:ǂݍSTLt@Cւ̃pX
){
	// Xg[I[v
	std::ifstream in(strFilePath, std::ios_base::binary);
	if(!in){
		int state = in.rdstate();
		// I[vsꍇAG[R[hԋp
		return state;
	}

	Initialize();
	int error; // t@Cǂݍ݂̌ʂێ
	std::vector<MGPosition> vecPos;
	if(IsBinaryFile(in)){
		// Load Binary File
		error = LoadBinary(in, vecPos);
	}else{
		// Load Ascii File
		error = LoadAscii(in, vecPos);
	}
	
	if(error){ // 0:ɓǂݍ݂ ȊO̒l:ǂݍ݂s
		// ǂݍ݂sꍇAG[R[hԋp
		return error;
	}

	// gXݒ
	double wc_zero_old = MGTolerance::set_wc_zero(m_box.length()*MGTolerance::rc_zero());
	// ǂݍ񂾍Wlm_indices, m_vecNormlTriangݒ
	set_mesh_data(vecPos);
	MGTolerance::set_wc_zero(wc_zero_old);

	// fobOR[h
	//std::cout << "stlt@Cǂݍ" << std::endl;
	//std::cout << "Op` " << m_vecNormlTriang.size() << std::endl;
	//std::cout << "_ " << m_vecPos.size() << std::endl;
	//std::cout << "{bNXgW"<<  std::endl;
	//std::cout << "ŏl " << std::endl;
	//std::cout << "X " << m_box.low()(0) << std::endl;
	//std::cout << "Y " << m_box.low()(1) << std::endl;
	//std::cout << "Z " << m_box.low()(2) << std::endl;
	//std::cout << "ől " << std::endl;
	//std::cout << "X " << m_box.high()(0) << std::endl;
	//std::cout << "Y " << m_box.high()(1) << std::endl;
	//std::cout << "Z " << m_box.high()(2) << std::endl << std::endl;
	// G[R[hԋp(ɓǂݍ݂)
	return error;
}

// t@Cǂݍ񂾑SĂ̒_̍Wli[Ă
// vecPoseOp`̖@vZAm_vecNormlTriangɒǉ
// vecPos̊evf̍Wl̏dgXɔf
// d菜Am_vecPosɒǉ
// vecPos̊evf̃CfbNXm_indicesɒǉ
// :m_vecNormlTriang, m_indicesɒlݒ肳
void MGStl::set_mesh_data(
	const std::vector<MGPosition>& vecPos // [in]:t@Cǂݍ񂾍Wl̔z
){
	m_box.set_null();

	// t@Cǂ񂾒_Op`̐擾
	size_t nTriang = vecPos.size()/3;
	// Wlƒ_̃CfbNXꎞIɕێĂ}bv
	triangleMap VertexMap;
	for(size_t i = 0; i < nTriang; i++){
		// Op`̒_ԍ̔z̃CfbNX߂Ă
		size_t i3=i*3;
		const MGPosition& p0 = vecPos[i3++]; m_box.expand(p0);
		const MGPosition& p1=vecPos[i3++]; m_box.expand(p1);
		const MGPosition& p2=vecPos[i3]; m_box.expand(p2);
		// ܂A͂ꂽ3_ʂ̖@߁Am_vecNormlTriangpush_back
		// ɁAw肵_̍WɕۑĂ邩
		// ۑĂꍇ́AY钸_̃CfbNX󂯎
		// m_indicespush_back
		// ۑĂȂꍇ́A_m_vecPospush_back
		// ɃCfbNX+1A󂯎m_indicespush_back
		push_back_triangle(p0, p1, p2, VertexMap);
	}
}

// Ascii`̃t@CǂݍݑSĂ̍Wl擾
// ܂}`̃{bNXgݒ肷
// ߂l: =0t@C̓ǂݍ
//		  !=0 ǂݍ݂Ɏs(std::ifstream̃G[R[h)
// O:ɃI[vꂽt@CXg[n
// :vecPosɑSĂ̍Wli[A boxɃ{bNXg̍Wlݒ肳
// t@CXg[i
int MGStl::LoadAscii(
	std::ifstream& in, // [in/out]:ɃI[vꂽt@CXg[
	std::vector<MGPosition>& vecPos // [out]:t@Cǂݍ񂾍Wl̔z
){
	// Keep one line data read from file
	std::string strLine;
	// Keep cordinate of vertex
	MGPosition position1(3), position2(3), position3(3);

	if(in.eof()){ // t@C̏ꍇ
		return std::ios_base::eofbit;
	}

	m_box.set_null();

	// t@Cfacet normal邩ϐ
	bool bStl = false;
	// G[`FbŇʂi[ϐ
	int readState;
	// Read file and set date to member
	while(getline(in, strLine)){
		// ǂݍ݃G[`FbN
		readState=in.rdstate();
		if(readState == std::ios::failbit || readState == std::ios::badbit){
			return readState; // G[R[hԋp(ǂݍ݂s)
		}

		if(strLine.find("facet normal") == -1){// sfacet normal݂邩
			continue;
		}
		// t@Cfacet normal𔭌
		bStl = true;
		// Triangle data
		std::string dummy;
		// outer loopsǂݔ΂
		in.ignore(10000, '\n');
		// Get cordinate of vertex
		in >> dummy >> position1(0) >> position1(1) >> position1(2);
		in >> dummy >> position2(0) >> position2(1) >> position2(2);
		in >> dummy >> position3(0) >> position3(1) >> position3(2);

		// ǂݍ݃G[`FbN
		readState = in.rdstate();
		if(readState){
			return readState; // G[R[hԋp(ǂݍ݂s)
		}

		// t@Cǂݍ񂾍Wlvectorpush_back
		vecPos.push_back(position1);
		vecPos.push_back(position2);
		vecPos.push_back(position3);
		// {bNXg3ƂAexpand
		m_box.expand(position1);
		m_box.expand(position2);
		m_box.expand(position3);
		// s
		in.seekg(1, std::ios::cur);
		// endloop endfacetsǂݔ΂
		in.ignore(10000, '\n');
		in.ignore(10000, '\n');
	}

	if(!bStl){
		// facet normalxǂ܂ɖs܂œǂݍ񂾏ꍇ
		// ܂Aʂ̎ނ̃t@Cǂ񂾏ꍇ̏
		return std::ios_base::eofbit;
	}

	// Ilԋp
	return 0;
}

// Binary`̃t@CǂݍݑSĂ̍Wl擾
// ܂}`̃{bNXgݒ肷
// ߂l: =0t@C̓ǂݍ
//		  !=0 ǂݍ݂Ɏs(std::ifstream̃G[R[h)
// O:ɃI[vꂽt@CXg[n
// :vecPosɑSĂ̍Wli[A m_boxɃ{bNXg̍Wlݒ肳
//			t@CXg[i
int MGStl::LoadBinary(
	std::ifstream& in, // [in/out]:ɃI[vꂽt@CXg[
	std::vector<MGPosition>& vecPos //[out]:t@Cǂݍ񂾍Wl̔z
){
	// Keep the point of vertex of triangle
	MGPosition position1(3), position2(3), position3(3);	

	// Skip the top of 80 byte
	in.seekg(80, std::ios::beg);
	// Get count of triangle
	int nTriang;
	in.read((char*)&nTriang, 4);

	// ݃G[`FbN
	int readState = in.rdstate();
	if(readState){
		return readState; // G[R[hԋp(ǂݍ݂s)
	}

	// Keep vertex and normal of triangle temporary 
	float fVertex1[3], fVertex2[3], fVertex3[3];

	m_box.set_null();
	// Read and set cordinate of vertex and normal of triangle
	for(int i = 0; i < nTriang; i++){
		// normali[Ă镔ǂݔ΂
		in.seekg(12, std::ios::cur);
		// Read cordinate of vertex from file
		for(int j = 0; j < 3; j++){
			in.read((char*)&fVertex1[j], 4);
			position1(j) = fVertex1[j];
		}
		for(int j = 0; j < 3; j++){
			in.read((char*)&fVertex2[j], 4);
			position2(j) = fVertex2[j];
		}
		for(int j = 0; j < 3; j++){
			in.read((char*)&fVertex3[j], 4);
			position3(j) = fVertex3[j];
		}

		// t@Cǂݍ񂾍Wlvectorpush_back
		vecPos.push_back(position1);
		vecPos.push_back(position2);
		vecPos.push_back(position3);
		// {bNXgexpand
		m_box.expand(position1);
		m_box.expand(position2);
		m_box.expand(position3);

		if(i == nTriang - 1){
			// Ō̎Op`̏ꍇ͓ǂݍݏI
			break;
		}
		// ̎Op`ꍇA2oCgXLbv
		in.seekg(2, SEEK_CUR);

		// ǂݍ݃G[`FbN
		readState = in.rdstate();
		if(readState){
			return readState; // G[R[hԋp(ǂݍ݂s)
		}
	}

	// ݃G[`FbN
	readState = in.rdstate();
	if(readState == std::ios::failbit || readState == std::ios::badbit){
		return readState; // G[R[hԋp(ǂݍ݂s)
	}

	// Ilԋp
	return 0;
}

// w肳ꂽpXAscii`STLt@Cۑ
// ߂l: =0t@C݂̏
//		  !=0 ܂ȂB܂͎s(std::ofstream̃G[R[h)
// O:m_vecPosm_vecNormlm_indicesɐ񂪓Ă
// :rSTLFilePathɎw肵pXAscii`STLt@Cۑ
//dlύXFɃXg[n悤ɕύX
int MGStl::SaveAscii(
	std::ofstream& fout
	//const char* rSTLFilePath // [in]:t@C̕ۑ̃pX
)const{
	//std::ofstream fout(rSTLFilePath);

	// ݃G[`FbN
	int writeState = fout.rdstate();
	if(writeState){
		return writeState; // G[R[hԋp(ǂݍ݂s)
	}

	fout.setf(std::ios::scientific);
	// solid
	fout << "solid ascii" << std::endl;
	// Op`̐擾(Op`̐ == ʖ@xNǧ)
	size_t nTriang = m_vecNormlTriang.size();
	// output normal of triangle and cordinate of vertex to file
	for(size_t i = 0; i < nTriang; i++){
		// Get triangle normal
		const MGUnit_vector& normal = m_vecNormlTriang[i];
		// facet normal
		fout << "    facet normal  " << normal(0) << " " << normal(1)<< " " << normal(2) << " " << std::endl;
		// outerloop
		fout << "        outer loop" << std::endl;
		
		// _̔ԍ̔z̓YvZĂ
		size_t index=i*3;
		// output cordinate of vertex to file
		const MGPosition& position1 = m_vecPos[m_indices[index++]];
		fout << "        vertex  " << position1(0) << " " << position1(1) << " " << position1(2) << " " << std::endl;
		const MGPosition& position2 = m_vecPos[m_indices[index++]];
		fout << "        vertex  " << position2(0) << " " << position2(1) << " " << position2(2) << " " << std::endl;
		const MGPosition& position3 = m_vecPos[m_indices[index]];
		fout << "        vertex  " << position3(0) << " " << position3(1) << " " << position3(2) << " " << std::endl;
		// outerloop
		fout << "        endloop" << std::endl;
		fout << "    endfacet" << std::endl;

		// ݃G[`FbN
		writeState = fout.rdstate();
		if(writeState){
			return writeState; // G[R[hԋp(ǂݍ݂s)
		}
	}
	// endsolid
	fout << "endsolid" << std::endl;
	fout.unsetf(std::ios::scientific);

	writeState = fout.rdstate();
	if(writeState == std::ios::failbit || writeState == std::ios::badbit){
		return writeState; // G[R[hԋp(݂s)
	}

	//fout.close();
	return 0;
}

// w肳ꂽpXBinary`STLt@Cۑ
// ߂l: =0t@C݂̏
//		  !=0 ܂ȂB܂͎s(std::ofstream̃G[R[h)
// O:m_vecPosm_vecNormlm_indicesɐ񂪓Ă
// :rSTLFilePathɎw肵pXBinary`STLt@Cۑ
int MGStl::SaveBinary(
	const TCHAR* rSTLFilePath  // [in]:t@C̕ۑ̃pX
)const{
	// File open
	std::ofstream fout(rSTLFilePath, std::ios::binary);
	// Xg[̃G[`FbN
	int writeState = fout.rdstate();
	if(writeState)
		return writeState;

	// Op`̐擾(Op`̐ == ʖ@xNǧ)
	int nTriang = (int)m_vecNormlTriang.size();
	// t@C擪80oCgXLbv
	fout.seekp(80, std::ios::beg);
	// t@CɎOp`̖
	fout.write((char*)&nTriang, 4);

	// ݃G[`FbN
	writeState = fout.rdstate();
	if(writeState){
		return writeState; // G[R[hԋp(݂Ɏs)
	}

	// Keep vertex and normal of triangle temporary 
	float fNormal, fVertex;
	// eOp`̏
	for(int i = 0; i < nTriang; i++){
		// Op`̖ʖ@xNg
		const MGUnit_vector& normal = m_vecNormlTriang[i];
		for(int j = 0; j < 3; j++){
			fNormal = float(normal[j]);
			fout.write((char*)&fNormal, 4);
		}

		// Op`̒_ԍ̔z̃CfbNX߂Ă
		int i3 = i*3;

		// xN^[璸_̃CfbNXwĂWlo
		// Op`̒_̍W
		const MGPosition& position1 = m_vecPos[m_indices[i3]];
		for(int j = 0; j < 3; j++){
			fVertex = float(position1[j]);
			fout.write((char*)&fVertex, 4);
		}
		
		const MGPosition& position2 = m_vecPos[m_indices[i3+1]];
		for(int j = 0; j < 3; j++)		{
			fVertex = float(position2[j]);
			fout.write((char*)&fVertex, 4);
		}
		
		const MGPosition& position3 = m_vecPos[m_indices[i3+2]];
		for(int j = 0; j < 3; j++){
			fVertex = float(position3[j]);
			fout.write((char*)&fVertex, 4);
		}

		// Ō̎Op`̏ꍇ͏݂I
		if(i == nTriang - 1){
			break;
		}

		// Op`Ƃ2oCgԊu󂯂
		fout.seekp(2, std::ios::cur);

		// ݃G[`FbN
		writeState = fout.rdstate();
		if(writeState){
			return writeState; // G[R[hԋp(݂Ɏs)
		}
	}
	// ݃G[`FbN
	writeState = fout.rdstate();
	if(writeState == std::ios::failbit || writeState == std::ios::badbit){
		return writeState;// G[R[hԋp(݂s)
	}

	fout.close();
	return 0;
}

// ͂łpositionVertexMapɂłɓo^Ă΂m_vecPosYԂ
// o^̏ꍇAVm_vecPosɊi[Apositionm_vecPosYmapVertexMap
// o^
int MGStl::IdentifyPosition(
	const MGPosition& position, // _̍W
	triangleMap& VertexMap // d̂Ȃ_̍WA_̃CfbNXێ
){
	m_box.expand(position);

	int nVertexIndex = (int)m_vecPos.size();
	//iteratorposition̍WlȏƂȂvf͂߂Čꏊw悤ɂ
	triangleMap::iterator itAft = VertexMap.lower_bound(position), itPre;
	if(itAft != VertexMap.end()){	//iteratorIwĂȂꍇ
		if(itAft->first==position)
			return itAft->second;	//wĂvfƈvꍇCindexԂ
	}
	if(itAft != VertexMap.begin()){	//iteratorn߂wĂȂꍇ
		itPre=itAft;itPre--;	//O̗vfpositionr
		if(itPre->first==position){
			return itPre->second;	//O̗vfƈvꍇCindexԂ
		}
	}

	VertexMap.insert(itAft, std::make_pair(position, nVertexIndex));
	m_vecPos.push_back(position);
	return nVertexIndex;
}

// of[^ފ֐
void MGStl::WriteMembers(MGOfstream& buf)const{
	MGObject::WriteMembers(buf);
	// Op`̖@xNg
	int nTriangle = (int)m_vecNormlTriang.size();
	buf << nTriangle;
	for(int i = 0; i < nTriangle; i++){
		m_vecNormlTriang[i].dump(buf);
	}

	// Op`̏dȂW̒_
	int nPos = (int)m_vecPos.size();
	buf << nPos;
	for(int k = 0; k < nPos; k++){
		m_vecPos[k].dump(buf);
	}

	// Op`̊e_̃CfbNX
	int nIndex = (int)m_indices.size();
	buf << nIndex;
	for(int l = 0; l < nIndex; l++){
		buf << m_indices[l];
	}
}

// of[^ǂݍފ֐
void MGStl::ReadMembers(MGIfstream& buf){
	MGObject::ReadMembers(buf);
	// Op`̖@xNgǂݍ
	int nTriangle;
	buf >> nTriangle;
	m_vecNormlTriang.resize(nTriangle);
	for(int i = 0; i < nTriangle; i++){	
		m_vecNormlTriang[i].restore(buf);
	}
	

	// Op`̊e_̍Wdǂݍ
	m_box.set_null();
	int nPos;
	buf >> nPos;
	m_vecPos.resize(nPos);
	for(int k = 0; k < nPos; k++){
		MGPosition& Pk=m_vecPos[k];
		Pk.restore(buf);
		m_box.expand(Pk);
	}

	// Op`̊e_̃CfbNXǂݍ
	int nIndex;
	buf >> nIndex;
	m_indices.resize(nIndex);
	for(int l = 0; l < nIndex; l++){
		buf >> m_indices[l];
	}
}

// xt@Cǂ݁Aoɒlݒ肳ꂽԂōĂуt@Cǂނ
// o̒l㏑B邽߁Ao̒lSăZbg
void MGStl::Initialize(){
	m_vecPos.clear();
	m_vecNormlTriang.clear();
	m_indices.clear();
}

// 3_쐬Op`̏oϐɒlݒ肷
// O:͂pos1, pos2, pos3͔vɂȂĂ邱
// :m_vecPos, m_vecNormlTriang, m_indicesɎOp`̏񂪐ݒ肳
// ܂A͂ꂽ3_ʂ̖@߁Am_vecNormlTriangpush_back
// ɁAw肵_̍WɕۑĂ邩
// ۑĂꍇ́AY钸_̃CfbNX󂯎
// m_indicespush_back
// ۑĂȂꍇ́A_m_vecPospush_back
// ɃCfbNX+1A󂯎m_indicespush_back
void MGStl::push_back_triangle(
	const MGPosition& pos1,
	const MGPosition& pos2,
	const MGPosition& pos3,
	triangleMap& VertexMap
){
	// 3_ʂ̖@߁Aoϐpush_back
	m_vecNormlTriang.push_back(UnitNormal(pos1, pos2, pos3));

	// m_indicesɒ_̃CfbNXpush_back
	// m_vecPosɏdȂMGPositionpush_back
	m_indices.push_back(IdentifyPosition(pos1, VertexMap)); m_box.expand(pos1);
	m_indices.push_back(IdentifyPosition(pos2, VertexMap)); m_box.expand(pos2);
	m_indices.push_back(IdentifyPosition(pos3, VertexMap)); m_box.expand(pos3);
}

// o[f[^𒼐ڃZbg
void MGStl::set_all_data(
	const std::vector<MGPosition>& vertices,
	const std::vector<int>& indices
){
	assert(indices.size() % 3 == 0);

	m_vecPos = vertices;
	m_indices = indices;

	// update normals and box
	compute_box(m_box);
	update_normals();
}

// Update the all normals of the triangles.
void MGStl::update_normals(){
	size_t nTri = m_indices.size() / 3;
	std::vector<MGUnit_vector> work(nTri);

	for(size_t i = 0; i < nTri; ++i){
		int vid[3];
		GetVertIndices((int)i, vid);
		assert(size_t(vid[0]) < m_vecPos.size());
		assert(size_t(vid[1]) < m_vecPos.size());
		assert(size_t(vid[2]) < m_vecPos.size());

		work[i] = UnitNormal(
			m_vecPos[vid[0]],
			m_vecPos[vid[1]],
			m_vecPos[vid[2]]);
	}

	work.swap(m_vecNormlTriang);
}

// ǂݍstlf[^objtH[}bgɕϊAo͂
// ߂l: =0 t@C݂̏
//        !=0 ܂ȂB܂͎s(std::ofstream̃G[R[h)
// :w肵pXobjt@Cۑ.
int MGStl::SaveObjFormatFromStl(
	std::ofstream& fout
)const{

	// ݃G[`FbN
	int writeState = fout.rdstate();
	if(writeState){
		return writeState; // G[R[hԋp(ǂݍ݂s)
	}

	// tOݒ
	// TODO ̖ړI̓zC[p̃f[^(P:mm)o͂̂ŁA
	// tOfixedɂĂ
	fout.setf(std::ios::fixed);

	// stlf[^œǂݍ񂾎Op`̌擾
	int nTriang = GetTriangleCount();

	// _W̏o
	for(int i0 = 0; i0 < nTriang; i0++){
		// _̔ԍ̔z̓YvZĂ
		int index = i0 * 3;

		// (Op`)_W擾Ao͂
		for(int i1 = 0; i1 < 3; i1++){
			const MGPosition& position = m_vecPos[m_indices[index + i1]];
			fout << "v " << position(0) << " " << position(1) << " " << position(2) << std::endl;
		}
	}

	// @xNg̏o
	for(int j = 0; j < nTriang; j++){
		// @xNg̎擾
		const MGUnit_vector& normal = m_vecNormlTriang[j];
		fout << "vn " << normal(0) << " " << normal(1) << " " << normal(2) << std::endl;
	}

	// ʏ̏o
	for(int k = 0; k < nTriang; k++){
		// stl`̃f[^ǂݍł邽߁Aʃf[^͑SĎOp`݂̂ɂȂĂ
		// o͂f[^̌`́A
		// v1//n1 v2//n1 v3//n1 ݂̂ł
		int n1 = k + 1; // @xNg
		fout << "f " << k * 3 + 1 << "//" << n1 << " " 
			         << k * 3 + 2 << "//" << n1 << " " 
					 << k * 3 + 3 << "//" << n1 << std::endl; 
	}

	// tO
	fout.unsetf(std::ios::fixed);

	// ݃G[`FbN
	writeState = fout.rdstate();
	if(writeState == std::ios::failbit || writeState == std::ios::badbit){
		return writeState; // G[R[hԋp(݂s)
	}

	return 0; // I
}
