#include "StdAfx.h"
#include "mgGL/mgGLFrameBufferObject.h"

mgGLFramebufferObject::mgGLFramebufferObject():
m_Width(0),m_Height(0),
	m_framebufferId(0),m_renderbufferId(0),m_textureId(0)
	,m_oldBufferId(0)
	,m_oldDrawBuf(GL_BACK)
	,m_pixFormat(GL_RGB)
{;}

bool mgGLFramebufferObject::CreateBuffer(int width, int height, GLenum format)
{
	ASSERT(width>0 && height>0);

	m_Width = width;
	m_Height = height;
	m_pixFormat = format;

	// t[obt@̐ƃoCh
	// ݂̃t[obt@ޔ
	glGetIntegerv(GL_FRAMEBUFFER_BINDING, &m_oldBufferId);
	glGenFramebuffers(1, &m_framebufferId);
	glBindFramebuffer(GL_FRAMEBUFFER, m_framebufferId);

	// eNX`̐ColorAttachment0ւ̊֘At
	glGenTextures(1, &m_textureId);
	glBindTexture(GL_TEXTURE_2D, m_textureId);
	glTexImage2D(GL_TEXTURE_2D,0,GL_RGBA8,width,height,0,m_pixFormat,GL_UNSIGNED_BYTE,NULL);
	glFramebufferTexture2D(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, GL_TEXTURE_2D, m_textureId, 0);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);

	// _[obt@̐DepthAttachmentւ̊֘At
	glGenRenderbuffers(1, &m_renderbufferId);
	glBindRenderbuffer(GL_RENDERBUFFER, m_renderbufferId);
	glFramebufferRenderbuffer(GL_FRAMEBUFFER, GL_DEPTH_ATTACHMENT, GL_RENDERBUFFER, m_renderbufferId);
	glRenderbufferStorage(GL_RENDERBUFFER, GL_DEPTH_COMPONENT24, width, height);

	// t[obt@̏Ԃ`FbN
	if(glCheckFramebufferStatus(GL_FRAMEBUFFER) != GL_FRAMEBUFFER_COMPLETE) {
		ReleaseBuffer();
		return false;
	}

	// t[obt@ɖ߂
	glBindFramebuffer(GL_FRAMEBUFFER, m_oldBufferId);
	m_oldBufferId = 0;

	return true;
}

/**
* N[Abvs܂B
*/
void mgGLFramebufferObject::ReleaseBuffer() {
	// Ât[obt@΃oCh
	if(m_oldBufferId) {
		glBindFramebuffer(GL_FRAMEBUFFER, m_oldBufferId);
		m_oldBufferId = 0;
	}

	// _[obt@̊J
	if(m_renderbufferId) {
		glDeleteRenderbuffers(1, &m_renderbufferId);
		m_renderbufferId = 0;
	}

	// eNX`̊J
	if(m_textureId) {
		glDeleteTextures(1, &m_textureId);
		m_textureId = 0;
	}

	// t[obt@̊J  
	if(m_framebufferId) {
		glDeleteFramebuffers(1, &m_framebufferId);
		m_framebufferId = 0;
	}
}


// _[eNX`Jn֐
void mgGLFramebufferObject::beginRenderTexture() {

	// ݂̃t[obt@ޔ
	glGetIntegerv(GL_FRAMEBUFFER_BINDING, &m_oldBufferId);

	// _[eNX`p̃t[obt@oCh
	glBindFramebuffer(GL_FRAMEBUFFER, m_framebufferId);
	glGetIntegerv(GL_DRAW_BUFFER, &m_oldDrawBuf);
	GLenum fboBuffers[]={GL_COLOR_ATTACHMENT0};
	glDrawBuffers(1, fboBuffers);
}

// _[eNX`I֐
void mgGLFramebufferObject::endRenderTexture() {
	glDrawBuffer(m_oldDrawBuf);
	// t[obt@ɖ߂
	glBindFramebuffer(GL_FRAMEBUFFER, m_oldBufferId);
	m_oldBufferId = 0;
}

// _[eNX`Rs[֐
void mgGLFramebufferObject::CopyRenderTexture(GLvoid* pixels) {
	glFlush();
	GLint oldReadBuf=GL_BACK;
	glGetIntegerv(GL_READ_BUFFER, &oldReadBuf);
	glReadBuffer(GL_COLOR_ATTACHMENT0);
	glReadPixels(0,0, m_Width, m_Height,m_pixFormat, GL_UNSIGNED_BYTE, pixels);
	glReadBuffer(oldReadBuf);
}

Gdiplus::Bitmap* mgGLFramebufferObject::readViewAsBitmap(){
	//// Change the pixel data format
	int width = getWidth();
	int height = getHeight();
	Gdiplus::Bitmap* bitmap = 0;//bitmap

	try{
		bitmap = new Gdiplus::Bitmap(width, height, PixelFormat32bppARGB);
	}catch(std::bad_alloc){
		delete bitmap;
		return 0;
	}

	Gdiplus::BitmapData bitmapData;
	Gdiplus::Rect rect(0, 0, width, height);
	Gdiplus::Status sts=bitmap->LockBits(&rect,
		Gdiplus::ImageLockModeRead|Gdiplus::ImageLockModeWrite,PixelFormat32bppARGB,&bitmapData);

	if(sts==Gdiplus::Ok){
		GLvoid* bgra = (GLvoid*)bitmapData.Scan0;
		glFlush();
		
		GLint oldReadBuf=GL_BACK;
		glGetIntegerv(GL_READ_BUFFER, &oldReadBuf);
		glReadBuffer(GL_COLOR_ATTACHMENT0);
		glReadPixels(0,0, width, height, GL_BGRA_EXT, GL_UNSIGNED_BYTE, bgra);
		glReadBuffer(oldReadBuf);
		glFinish();
		bitmap->UnlockBits(&bitmapData);
		bitmap->RotateFlip( Gdiplus::RotateNoneFlipY );

		return bitmap;
	}else{
		delete bitmap;
		return 0;
	}
}
