/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
//! @file
//!	@brief  Implementaion for class MGIgesOfstream.
//!	@author System fugen

#include "StdAfx.h"
#include "mgIges/IgesOfstream.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif
using namespace std;

#define LINE_LENGTH 72
//Write out start and terminate section into output file stream.
void MGIgesOfstream::write_out_start_section(){
	int i=0, n=(int)m_StartSection.length();
		//i is the position in m_StartSection to output next line out of Start section.

	int lineID=1;
	while(n-i>=LINE_LENGTH){
		m_ofstream<<m_StartSection.substr(i,LINE_LENGTH);
		m_ofstream<<'S'<<setw(7)<<setfill('0')<<lineID<<endl;
		i+=LINE_LENGTH;
		lineID++;
	}
	int redundant=n-i;
	if(redundant>0){
		m_ofstream<<left<<setw(LINE_LENGTH)
			<<setfill(' ')<<m_StartSection.substr(i,redundant);
		m_ofstream<<'S'<<setw(7)<<right<<setfill('0')<<lineID<<endl;
	}
}

//Write out all the Paramete Data Lines in m_plines to output file stream.
//m_plines[i] is one parameter data lines of IGES file
//for 0<=i<m_plines.size().
void MGIgesOfstream::write_out_PD_plines(){
	int plsize=(int)m_plines.size();//p[^f[^C̗̐
	for(int i=0;i<plsize;i++){//̐[v
		MGIgesParamLine& igespline=*(m_plines[i]);//iԖڂm_plines[i]̎QƐ̒l
		string& strng=igespline.paramLine();
			//paramLine()ƂANZbTgč̂Ăm_paramLineQ
		m_ofstream<<setw(65)<<setfill(' ')<<left<< strng;
		int de=igespline.DEpointer();
		m_ofstream<<setw(7)<<setfill('0')<<right<<MGIges::DEpointer_to_lnumber(de); 
		m_ofstream<<'P';
		int ip1=i+1;
		m_ofstream<<setw(7)<<setfill('0')<<right<<ip1<<endl;
	}
}

//Write out DEpointer's Paramete Data Lines into m_plines.
//Paramete Data Lines of m_DrectoryEntries[DEpointer] will be
//output into m_plines.
//Function's return value is the number of lines output.
int MGIgesOfstream::write_out_PD_pline(int DEpointer){
	UniqueDE& de=directoryEntry(DEpointer);
	const unique_ptr<MGIgesPD>& pd=de->paramData();

	std::vector<std::string> plines;
	MGIges::put_integer(pd->type_number(),m_GSection,plines);
	pd->write_out_into_string(m_GSection,plines);
	MGIges::append_record_delimeter(m_GSection.recordDelimeter(),plines);

	int n=(int)plines.size();
	for(int i=0; i<n; i++){
		m_plines.emplace_back(new MGIgesParamLine(std::move(plines[i]),DEpointer));
	}
	return n;
}

//Write out DE lines to output file stream, together with PD lines.
//write_out_DE_PD_lines outputs all the DEs and PDs using 
//write_out_PD_pline for each DE.
void MGIgesOfstream::write_out_DE_PD_lines(){
	//cd̔z̃TCY߁AׂĂ̂cdplineɏo͂Ă
	int sum_DE = (int)m_DirectoryEntries.size();
	for(int i=1;i<sum_DE;i++){//i starts from 1 since 1st DE is dummy.
		int PDpointer=get_next_param_line_count();
		int line_count=write_out_PD_pline(i);
		MGIgesDirectoryEntry& deNum = *(m_DirectoryEntries[i]);
		string DElines[2];
		deNum.put_to_string(PDpointer, line_count, i,DElines);
		m_ofstream<<DElines[0]<<endl;
		m_ofstream<<DElines[1]<<endl;
	}
	write_out_PD_plines();//o͗p̃t@C𐶐At@Cɏ
}

void MGIgesOfstream::write_out_terminate_section(){
	int slineSize=MGIgesFstream::get_line_number_of_SS();
	m_ofstream<<'S';
	m_ofstream<<setw(7)<<setfill('0')<<slineSize;

	int nlinegsec=MGIgesFstream::get_line_number_of_GS();
	m_ofstream<<'G';
	m_ofstream<<setw(7)<<setfill('0')<<nlinegsec;

	int dlineSize=MGIgesFstream::get_line_number_of_DE();
	m_ofstream<<'D';
	m_ofstream<<setw(7)<<setfill('0')<<dlineSize;

	int mlineSize=MGIgesOfstream::get_line_number_of_PD();
	m_ofstream<<'P';
	m_ofstream<<setw(7)<<setfill('0')<<mlineSize;

	m_ofstream<<setw(41)<<setfill(' ')<<('T');
	m_ofstream<<setw(7)<<setfill('0')<<'1'<<endl;
}
