/////////////////////////////////////////////////////////////////////////
// CConfigInfo 饹Υ󥿥ե
//
////////////////////////////////////////////////////////////////////////////

#if !defined( CONFIGINFO_H_INCLUDED_ )
#define CONFIGINFO_H_INCLUDED_

#include <Xm/XmAll.h>
#include "TaEdit_std.h"

#include <map>

using namespace std;


class CConfigInfo : public CCPInterface
{
public:
	CConfigInfo( Widget widget );

	~CConfigInfo();

	// 
	void Initialize();

	const CCompoundStr& RefOkStr() const;
	const CCompoundStr& RefCancelStr() const;
	const CCompoundStr& RefYesStr() const;
	const CCompoundStr& RefNoStr() const;
	const string& RefNewFileWndTitleStr() const;
	const CCompoundStr& RefFailToConvertCharSet() const;
	const CCompoundStr& RefBrokenLineMsg() const;
	const CCompoundStr& RefIOErrorMsg( int ErrorNo ) const;
	const CCompoundStr& RefFileNameIsNotInputtedErrorMsg() const;
	const CCompoundStr& RefOutOfMemoryErrorMsg() const;
	const CCompoundStr& RefUnexpectedErrorMsg() const;
	const CCompoundStr& RefFileIsNotExistMsg() const;
	const CCompoundStr& RefSpecifiedNameIsDirMsg() const;
	const CCompoundStr& RefFaultFileOpenMsg() const;
	const CCompoundStr& RefPreservationCheckMsg() const;
	const CCompoundStr& RefRunScriptEAGAINMsg() const;
	const CCompoundStr& RefRunScriptEINTRMsg() const;
	const CCompoundStr& RefRunScriptENOMEMMsg() const;
	const CCompoundStr& RefRunScriptCancelOpenMsg() const;
	const CCompoundStr& RefRunScriptCancelSaveMsg() const;
	const CCompoundStr& RefRunScriptErrnoMsg( int e ) const;
	bool GetShowCancelOpenMsg() const;
	bool GetShowCancelSaveMsg() const;
	bool GetFaultLoadPluginLibraryMsg( CCompoundStr *pCS, const string &rLibraryName, const char* pReason ) const;
	bool GetFaultGetPluginFunctionMsg( CCompoundStr *pCS, const string &rLibraryName, const string &rFunctionName, const char* pReason ) const;
	const CCompoundStr& RefFailToGetPID() const;
	const CCompoundStr& RefFailToCreateChildProcess() const;
	const CCompoundStr& RefFileOpenDlgTitle() const;
	const CCompoundStr& RefFileSaveDlgTitle() const;
	Pixel RefNormalTextF_Color() const;
	Pixel RefNormalTextB_Color() const;
	Pixel RefSelectedTextF_Color() const;
	Pixel RefSelectedTextB_Color() const;
	Pixel RefBackgroundColor() const;
	Pixel RefCursorColor() const;
	Pixel RefPreEditTextF_Color() const;
	Pixel RefPreEditTextB_Color() const;
	const string& RefFontName() const;
	int RefTabWidth() const;
	const CCompoundStr& RefCantFindTextMsg() const;
	bool GetWrongRegexPatternMsg( CCompoundStr *pCS, const wstring &msg, int idx ) const;
	const wstring& RefWRP_EofNotAnticipated() const;
	const wstring& RefWRP_OutOfMemory() const;
	const wstring& RefWRP_UncertainChar() const;
	const wstring& RefWRP_ZeroLengthPattern() const;
	const wstring& RefWRP_Unexpected() const;
	const string& RefAppTitle() const;
	enumCHARSELTYPE GetCharSelType() const;
	unsigned int GetLeftPadding() const;
	unsigned int GetRightPadding() const;
	int GetLineNumberOrigin() const;
	int GetLineGapWidth() const;
	enumTABWIDTHCALCMETHOD GetTabWidthCalculationMethod() const;
	const wstring& RefTabString() const;
	const string& RefProcUpScript() const;
	const string& RefFileReadScript() const;
	const string& RefFileAfterReadScript() const;
	const string& RefFileBeforeWriteScript() const;
	const string& RefFileWriteScript() const;
	const string& RefFileCloseScript() const;
	const string& RefProcDownScript() const;
	bool GetAutoIndent() const;
	const wstring& RefIndentChar() const;
	const wstring& RefWordCharSet() const;
	enumDROPFILEOPENMETHOD GetDropFileOpenMethod() const;
	enumBTN2FUNC GetBtn2Func() const;
	int GetMaxUndoCount() const;
	unsigned int GetHScrollAt() const;
	const string& RefClipboardEncode() const;
	int GetShowPrecessingDlgDelay() const;
	int GetWindowWidth() const;
	int GetWindowHeight() const;
	int GetScrollMouseSpeed() const;
	const string& RefIconImageName() const;
	int GetExInfoColumnCount() const;
	int GetExInfoColumnWidth() const;
	Pixel RefExInfoColumnColor( int idx ) const;
	bool GetDrawSeparatorLine() const;
	Pixel RefSeparatorLineColor() const;
	int GetAutoSaveInterval() const;
	enumAUTOSAVE_NEWFILE GetAutoSaveNewFileMethod() const;

	// Ƹ̤
	unsigned int GetLangTypeEnableMaxSize() const;
	const string& RefCPP_FileExt() const;
	const string& RefJAVA_FileExt() const;
	const string& RefCOBOL_FileExt() const;
	const string& RefJS_FileExt() const;
	const string& RefVBS_FileExt() const;
	const string& RefCS_FileExt() const;
	Pixel RefCPP_NormalTextF_Color() const;
	Pixel RefCPP_KeywordF_Color() const;
	Pixel RefCPP_CommentF_Color() const;
	Pixel RefCPP_SringF_Color() const;
	Pixel RefJAVA_NormalTextF_Color() const;
	Pixel RefJAVA_KeywordF_Color() const;
	Pixel RefJAVA_CommentF_Color() const;
	Pixel RefJAVA_SringF_Color() const;
	Pixel RefCOBOL_NormalTextF_Color() const;
	Pixel RefCOBOL_KeywordF_Color() const;
	Pixel RefCOBOL_CommentF_Color() const;
	Pixel RefCOBOL_SringF_Color() const;
	Pixel RefCOBOL_SequenceNumberF_Color() const;
	Pixel RefJS_NormalTextF_Color() const;
	Pixel RefJS_KeywordF_Color() const;
	Pixel RefJS_CommentF_Color() const;
	Pixel RefJS_SringF_Color() const;
	Pixel RefVBS_NormalTextF_Color() const;
	Pixel RefVBS_KeywordF_Color() const;
	Pixel RefVBS_CommentF_Color() const;
	Pixel RefVBS_SringF_Color() const;
	Pixel RefCS_NormalTextF_Color() const;
	Pixel RefCS_KeywordF_Color() const;
	Pixel RefCS_CommentF_Color() const;
	Pixel RefCS_SringF_Color() const;

	const string& RefPluginConfigFileName() const;
protected:
	// ̾Pixelͤ
	Pixel GetColorByName( const string& rStr, Pixel DefColor, Colormap argCM, Display *pDisplay, map< string, Pixel > *pPixelCash ) const;

	Widget m_Widget;

	CCompoundStr OkStr;
	CCompoundStr CancelStr;
	CCompoundStr YesStr;
	CCompoundStr NoStr;
	string NewFileWndTitleStr;
	CCompoundStr FailToConvertCharSet;
	CCompoundStr BrokenLineMsg;
	CCompoundStr DeviceIOErrorMsg;
	CCompoundStr TextEncodeErrorMsg;
	CCompoundStr IOErrorMsg;
	CCompoundStr OutOfMemoryErrorMsg;
	CCompoundStr FileNameIsNotInputtedErrorMsg;
	CCompoundStr UnexpectedErrorMsg;
	CCompoundStr FileIsNotExistMsg;
	CCompoundStr SpecifiedNameIsDirMsg;
	CCompoundStr FaultFileOpenMsg;
	CCompoundStr PreservationCheckMsg;
	CCompoundStr RunScriptEAGAINMsg;
	CCompoundStr RunScriptEINTRMsg;
	CCompoundStr RunScriptENOMEMMsg;
	CCompoundStr RunScriptCancelOpenMsg;
	CCompoundStr RunScriptCancelSaveMsg;
	bool ShowCancelOpenMsg;
	bool ShowCancelSaveMsg;
	string FaultLoadPluginLibraryMsg;
	string FaultGetPluginFunctionMsg;
	CCompoundStr FailToGetPID;
	CCompoundStr FailToCreateChildProcess;
	CCompoundStr FileOpenDlgTitle;
	CCompoundStr FileSaveDlgTitle;

	Pixel NormalTextF_Color;
	Pixel NormalTextB_Color;
	Pixel SelectedTextF_Color;
	Pixel SelectedTextB_Color;
	Pixel BackgroundColor;
	Pixel CursorColor;
	Pixel PreEditTextF_Color;
	Pixel PreEditTextB_Color;
	string FontName;
	int TabWidth;
	CCompoundStr CantFindTextMsg;
	wstring WrongRegexPatternMsg;
	wstring WRP_EofNotAnticipated;
	wstring WRP_OutOfMemory;
	wstring WRP_UncertainChar;
	wstring WRP_ZeroLengthPattern;
	wstring WRP_Unexpected;
	string AppTitle;
	enumCHARSELTYPE CharSelType;
	unsigned int LeftPadding;
	unsigned int RightPadding;
	int LineNumberOrigin;
	int LineGapWidth;
	enumTABWIDTHCALCMETHOD TabWidthCalculationMethod;
	wstring TabString;
	string ProcUpScript;
	string FileReadScript;
	string FileAfterReadScript;
	string FileBeforeWriteScript;
	string FileWriteScript;
	string FileCloseScript;
	string ProcDownScript;
	bool AutoIndent;
	wstring IndentChar;
	wstring WordCharSet;
	enumDROPFILEOPENMETHOD DropFileOpenMethod;
	enumBTN2FUNC Btn2Func;
	int MaxUndoCount;
	unsigned int HScrollAt;
	string ClipboardEncode;
	int ShowPrecessingDlgDelay;
	int WindowWidth;
	int WindowHeight;
	int ScrollMouseSpeed;
	string IconImageName;
	int ExInfoColumnCount;
	int ExInfoColumnWidth;
	Pixel *pExInfoColumnColor;
	bool DrawSeparatorLine;
	Pixel SeparatorLineColor;
	int AutoSaveInterval;
	enumAUTOSAVE_NEWFILE AutoSaveNewFileMethod;

	unsigned int LangTypeEnableMaxSize;
	string CPP_FileExt;
	string JAVA_FileExt;
	string COBOL_FileExt;
	string JS_FileExt;
	string VBS_FileExt;
	string CS_FileExt;
	
	Pixel CPP_NormalTextF_Color;
	Pixel CPP_KeywordF_Color;
	Pixel CPP_CommentF_Color;
	Pixel CPP_SringF_Color;
	Pixel JAVA_NormalTextF_Color;
	Pixel JAVA_KeywordF_Color;
	Pixel JAVA_CommentF_Color;
	Pixel JAVA_SringF_Color;
	Pixel COBOL_NormalTextF_Color;
	Pixel COBOL_KeywordF_Color;
	Pixel COBOL_CommentF_Color;
	Pixel COBOL_SringF_Color;
	Pixel COBOL_SequenceNumberF_Color;
	Pixel JS_NormalTextF_Color;
	Pixel JS_KeywordF_Color;
	Pixel JS_CommentF_Color;
	Pixel JS_SringF_Color;
	Pixel VBS_NormalTextF_Color;
	Pixel VBS_KeywordF_Color;
	Pixel VBS_CommentF_Color;
	Pixel VBS_SringF_Color;
	Pixel CS_NormalTextF_Color;
	Pixel CS_KeywordF_Color;
	Pixel CS_CommentF_Color;
	Pixel CS_SringF_Color;


	string PluginConfigFileName;
};

#endif // CONFIGINFO_H_INCLUDED_
