////////////////////////////////////////////////////////////////////////////
// CCursor 饹Υ󥿥ե
//
////////////////////////////////////////////////////////////////////////////

#if !defined( CURSOR_H_INCLUDED_ )
#define CURSOR_H_INCLUDED_

#include "TaEdit_std.h"
#include "LineData.h"


#include <X11/keysym.h>
#include "ScrollInfoPacket.h"
#include "TaEditDoc.h"
#include "XimMgr.h"

class CTaEditDraw;

class CCursor : public CCPInterface
{
public:
	CCursor( const CTaEditDraw *argpDraw, const CTaEditDoc *argpDoc, VClsPtr< CXimMgr > argXimMgr );
	~CCursor();

	// ֤
	void SetCurPos( T_CurPos argPos, ScrollInfoPacket *pPacket, bool OnShift, bool RedrawCursor = TRUE );
	void SetCurPos( T_CurPos argPos, ScrollInfoPacket *pPacket, const T_SelRange& rArgSelRange, bool RedrawCursor = TRUE );

	// ֤ȤΥ
	void OnTimer();

	// 褵줿
	void OnRedraw();

	// ΰư
	void Up( ScrollInfoPacket *pPacket, bool OnShift );
	void Down( ScrollInfoPacket *pPacket, bool OnShift );
	void Right( ScrollInfoPacket *pPacket, bool OnShift, bool OnCtrl );
	void Left( ScrollInfoPacket *pPacket, bool OnShift, bool OnCtrl );
	void PageUp( ScrollInfoPacket *pPacket, bool OnShift );
	void PageDown( ScrollInfoPacket *pPacket, bool OnShift );
	void End( ScrollInfoPacket *pPacket, bool OnShift, bool OnCtrl );
	void Home( ScrollInfoPacket *pPacket, bool OnShift, bool OnCtrl );

	// ñ
	void SelectWord( ScrollInfoPacket *pPacket, const T_CurPos &rPos );

	// ֤μ
	const T_CurPos& GetCurPos() const;

	// XIMΰ֤ꤹ
	void RefleshXIMPos() const;

	// ꤵ줿ʸϰϤ˴ޤޤƤ뤫ݤ
	bool IsCharSelected( const T_CurPos &r ) const;

	// ϰϤ
	const T_SelRange& GetSelRange() const;

	// ֡XɸˤʥƥȤƬ0Ȥ͡
	int GetCurPosX() const;

protected:
	// ̤򥹥뤹ɬפ̵ͭȽǤ
	void JdgIsScroll( ScrollInfoPacket *pPacket ) const;

	// ˤϰϤѲ
	void ProcSelRange( const T_CurPos &Before, const T_CurPos &After, bool OnShift, ScrollInfoPacket *pPacket );

	// ϰϤѲԤϰϤ
	void Calc_SRChangeLine( int *pSLine, int *pELine, const T_SelRange& rSR1, const T_SelRange& rSR2 ) const;

	// ڤꡦԡ˥塼̵ͭ򹹿
	void UpdateCopyPasteMenuSensitive() const;

	// ꤵ줿֤Xɸ
	int CalcXPosition( T_CurPos pos ) const;

	// ֤򻻽Сʲ̤κ0Ȥ͡
	void CalcDrawCurPos( int *px, int *py ) const;

	// ꤵ줿Ԥˤơꤵ줿Xɸ˺Ǥᤤʸ֤򻻽Ф
	int CalcCPosByXPosition( int line, int xpos ) const;

	// ññ̤Ǥΰưˤơư
	int WordSkip( const wstring &rStr, int cpos, int IsRight, const wstring &rWordCharSet ) const;

protected:
	const CTaEditDoc *pDoc;
	T_CurPos CurPos;	// Τ֡ʹԡ
	int xpPos;	// Ǹ˥褷֡
	int ypPos;	// Ʊ

	bool CurDFlg;	// 뤬褵Ƥ뤫ݤ

	T_SelRange SelRange;	// ϰ	// ϰϤ0ʸξ
						// 򤵤ƤʤȤ򼨤
	T_CurPos SelStartPos;	// 򳫻Ϥ

	const CTaEditDraw *pDraw;	// ɥå
	VClsPtr< CXimMgr > pXimMgr;	// XIM֥

};

#endif // CURSOR_H_INCLUDED_

