////////////////////////////////////////////////////////////////////////////
// CMouse 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "Mouse.h"
#include "TaEditDraw.h"
#include "CurPos.h"
#include "TaEditShell.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CMouse::CMouse( VClsPtr< CCursor > argpCursor, const CTaEditDraw *argpDraw, VClsPtr< CTextEdit > argpEditor ) :
	pCursor( argpCursor ), pDraw( argpDraw ), MouseStatus( TAMS_NORMAL ), pEditor( argpEditor ), LastEvent( TAE_BUTTON1_UP )
{

}

CMouse::~CMouse()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
void CMouse::CreateCursor( Widget w )
{
	m_DestWgt = w;
	Display *pDisplay = XtDisplay( m_DestWgt );
	Window window = XtWindow( m_DestWgt );
	IBeamCursor = XCreateFontCursor( pDisplay, XC_xterm );
	ArrowCursor = XCreateFontCursor( pDisplay, XC_left_ptr );
	CurrentCursor = -1;
}

// Iӡݥ󥿤ѹ
void CMouse::SetIBeam()
{
	// ѹɬפʤСʤ
	if ( 1 == CurrentCursor ) return ;
	CurrentCursor = 1;

	Display *pDisplay = XtDisplay( m_DestWgt );
	Window window = XtWindow( m_DestWgt );
	XUndefineCursor( pDisplay, window );
	XDefineCursor( pDisplay, window, IBeamCursor );
}

// ݥ󥿤ѹ
void CMouse::SetArrow()
{
	// ѹɬפʤСʤ
	if ( 0 == CurrentCursor ) return ;
	CurrentCursor = 0;

	Display *pDisplay = XtDisplay( m_DestWgt );
	Window window = XtWindow( m_DestWgt );
	XUndefineCursor( pDisplay, window );
	XDefineCursor( pDisplay, window, ArrowCursor );
}

// ޥΥ٥
// x,yˤͤʤɡɥϰϤĶͤꤵ礬롣
void CMouse::OnMouse( TA_EVENT argEvent, int x, int y, ScrollInfoPacket *pPacket, bool OnShift, bool OnCtrl )
{
	// ޥΰ֤顢ƥȾǤΰ֤򻻽
	T_CurPos wCurPos = pDraw->PixPosToCurPos( x, y );
	
	switch ( argEvent ) {
	case TAE_BUTTON1_DOWN:
		if ( LastEvent == TAE_BUTTON1_DOWN ) return ;
		LastEvent = TAE_BUTTON1_DOWN;

		if ( OnCtrl ) {
			// CtrlƤϡñԤ
			pCursor->SelectWord( pPacket, wCurPos );
			MouseStatus = TAMS_SELECT;
			return ;
		}

		// ޥ줿Ȥʸ֤¸
		MouseDownPos = wCurPos;
		if ( pCursor->IsCharSelected( MouseDownPos ) ) {
			// ϰϾǡޥ줿
			MouseStatus = TAMS_TEXTMOVE;
			TextMoveSource = pCursor->GetSelRange();
		}
		else {
			// ΰ֤
			MouseStatus = TAMS_SELECT;
			pCursor->SetCurPos( wCurPos, pPacket, OnShift );
		}
		break;

	case TAE_BUTTON1_UP:
		if ( LastEvent == TAE_BUTTON1_UP ) return ;
		LastEvent = TAE_BUTTON1_UP;

		// ϰäϡ⡼ѹΤߤԤλ
		if ( MouseStatus == TAMS_SELECT ) {
			MouseStatus = TAMS_NORMAL;
			return ;
		}
		MouseStatus = TAMS_NORMAL;

		// ƥȰưäϡƥȤΰưԤ

		// ϰϤǥ뤬줿顢ä˽ϹԤʤ
		if ( pCursor->IsCharSelected( wCurPos ) ) {
			// ޥ줿ȤƱ줿ȤϡϰβԤ
			if ( MouseDownPos == wCurPos )
				pCursor->SetCurPos( MouseDownPos, pPacket, T_SelRange( MouseDownPos, MouseDownPos ) );
			return ;
		}

		// ƥȤΰưؼ
		pEditor->MoveText( TextMoveSource, x, y );

		break;

	case TAE_MOTION:
		if ( LastEvent != TAE_MOTION && LastEvent != TAE_BUTTON1_DOWN ) return ;
		LastEvent = TAE_MOTION;

		switch ( MouseStatus ) {
		case TAMS_SELECT:
			// ΰ֤
			pCursor->SetCurPos( wCurPos, pPacket, true );
			break;
		case TAMS_TEXTMOVE:
			// ϰǤϤʤΰ֤
			pCursor->SetCurPos( wCurPos, pPacket, TextMoveSource );
			break;
		}
		break;

	default:
		MouseStatus = TAMS_NORMAL;
		return ;
	}
}

// ޥݥ󥿰ưΥ٥
void CMouse::OnPointerMotion( int x, int y )
{
	// ޥΰ֤顢ƥȾǤΰ֤򻻽
	T_CurPos wCurPos = pDraw->PixPosToCurPos( x, y );

	// ݥ󥿤η
	if ( pCursor->IsCharSelected( wCurPos ) )
		SetArrow();
	else
		SetIBeam();
}

// ߤΥޥξ֤
TA_MOUSE_STATUS CMouse::GetMouseStatus() const
{
	return MouseStatus;
}

